/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.BiFunction;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;

class UriCoercer
extends TypeCoercer<URI> {
    UriCoercer() {
    }

    @Override
    public boolean test(Class<?> type) {
        return URI.class.isAssignableFrom(type);
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, URI> apply(Type type) {
        return (jsonInput, propertySetting) -> {
            String toCoerce;
            switch (jsonInput.peek()) {
                case NAME: {
                    toCoerce = jsonInput.nextName();
                    break;
                }
                case STRING: {
                    toCoerce = jsonInput.nextString();
                    break;
                }
                default: {
                    throw new JsonException("Unable to coerce type to URI: " + String.valueOf((Object)jsonInput.peek()));
                }
            }
            try {
                return new URI(toCoerce);
            }
            catch (URISyntaxException e) {
                throw new JsonException(e);
            }
        };
    }
}

