/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.util;

import java.text.SimpleDateFormat;
import java.util.Random;

public class Filename {
    private static Random RAND = new Random();
    private final String name;
    private final String ext;

    public Filename(String name, String ext) {
        this.name = name;
        this.ext = ext;
    }

    public String getName() {
        return this.name;
    }

    public String getExtension() {
        return this.ext;
    }

    public Filename asRandomFilename() {
        int nextInt = RAND.nextInt();
        SimpleDateFormat sf = new SimpleDateFormat("_yyyy-MM-dd_HH-mm-ss_");
        return new Filename(this.name + sf.format(System.currentTimeMillis()) + Integer.toHexString(nextInt), this.ext);
    }

    public String toString() {
        return this.ext.isEmpty() ? this.name : this.name + "." + this.ext;
    }

    public static Filename splitFilename(String name) {
        int lastPeriod = name.lastIndexOf(46);
        if (lastPeriod < 0) {
            return new Filename(name, "");
        }
        return new Filename(name.substring(0, lastPeriod), name.substring(lastPeriod + 1));
    }
}

