/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;

public final class StringToolkit {
    private StringToolkit() {
        throw new AssertionError((Object)"This is not the constructor you are looking for!");
    }

    public static String readString(InputStream in) throws IOException {
        return StringToolkit.readString(in, StandardCharsets.UTF_8);
    }

    public static String readString(InputStream in, Charset charset) throws IOException {
        ByteArrayOutputStream buf = StringToolkit.read(in);
        return buf.toString(charset);
    }

    public static String readString(InputStream in, String charsetName) throws IOException {
        ByteArrayOutputStream buf = StringToolkit.read(in);
        return buf.toString(charsetName);
    }

    private static ByteArrayOutputStream read(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            buf.write((byte)result);
            result = bis.read();
        }
        return buf;
    }

    public static String encodeFilename(String string) {
        return URLEncoder.encode(string, StandardCharsets.UTF_8);
    }

    public static String join(Collection<?> s, String delimiter) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> iter = s.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) break;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static String join(Object[] a, String delimiter) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < a.length - 1; ++i) {
            builder.append(String.valueOf(a[i]));
            builder.append(delimiter);
        }
        builder.append(a[a.length - 1]);
        return builder.toString();
    }
}

