/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.editor;

import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.EditorPart;
import org.openjdk.jmc.console.agent.editor.AgentEditorAction;
import org.openjdk.jmc.console.agent.editor.AgentEditorInput;
import org.openjdk.jmc.console.agent.editor.AgentEditorUi;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.rjmx.IServerHandle;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.IConnectionListener;
import org.openjdk.jmc.ui.WorkbenchToolkit;
import org.openjdk.jmc.ui.misc.CompositeToolkit;

public class AgentEditor
extends EditorPart
implements IConnectionListener {
    public static final String EDITOR_ID = "org.openjdk.jmc.console.agent.editor.AgentEditor";
    private Composite parentComposite;
    private FormToolkit formToolkit;
    private StackLayout stackLayout;
    private Form form;

    public void onConnectionChange(IConnectionHandle connection) {
        boolean serverDisposed;
        boolean bl = serverDisposed = this.getAgentEditorInput().getServerHandle().getState() == IServerHandle.State.DISPOSED;
        if (serverDisposed) {
            WorkbenchToolkit.asyncCloseEditor((IEditorPart)this);
            return;
        }
        if (!connection.isConnected() && this.form != null) {
            this.form.setMessage(Messages.AgentEditor_CONNECTION_LOST, 3);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        this.parentComposite.setFocus();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        try {
            this.getAgentEditorInput();
        }
        catch (Exception e) {
            throw new PartInitException(e.getMessage(), (Throwable)e);
        }
        this.setPartName(this.getAgentEditorInput().getName());
        this.getAgentEditorInput().getAgentJmxHelper().addConnectionChangedListener(this);
    }

    protected AgentEditorInput getAgentEditorInput() {
        IEditorInput input = super.getEditorInput();
        AgentEditorInput aei = input instanceof AgentEditorInput ? (AgentEditorInput)input : (AgentEditorInput)input.getAdapter(AgentEditorInput.class);
        if (aei == null) {
            throw new RuntimeException("The agent editor cannot handle the provided editor input");
        }
        return (AgentEditorInput)super.getEditorInput();
    }

    public void createPartControl(Composite parent) {
        this.parentComposite = parent;
        this.stackLayout = new StackLayout();
        this.parentComposite.setLayout((Layout)this.stackLayout);
        this.formToolkit = new FormToolkit(FlightRecorderUI.getDefault().getFormColors(Display.getCurrent()));
        this.formToolkit.setBorderStyle(0);
        this.stackLayout.topControl = this.formToolkit.createComposite(parent);
        ProgressIndicator progressIndicator = CompositeToolkit.createWaitIndicator((Composite)((Composite)this.stackLayout.topControl), (FormToolkit)this.formToolkit);
        progressIndicator.beginTask(1);
        this.createAgentEditorUi(parent);
    }

    private void createAgentEditorUi(Composite parent) {
        this.form = this.formToolkit.createForm(parent);
        this.form.setText(Messages.AgentEditor_AGENT_EDITOR_TITLE);
        this.form.setImage(this.getTitleImage());
        this.formToolkit.decorateFormHeading(this.form);
        IToolBarManager manager = this.form.getToolBarManager();
        AgentEditorAction[] actions = new AgentEditorAction[]{new AgentEditorAction(AgentEditorAction.AgentEditorActionType.REFRESH), new AgentEditorAction(AgentEditorAction.AgentEditorActionType.LOAD_PRESET), new AgentEditorAction(AgentEditorAction.AgentEditorActionType.SAVE_AS_PRESET)};
        Stream.of(actions).forEach(arg_0 -> ((IToolBarManager)manager).add(arg_0));
        Stream.of(actions).forEach(action -> action.setEnabled(false));
        this.form.updateToolBar();
        Composite body = this.form.getBody();
        body.setLayout((Layout)new FillLayout());
        AgentEditorUi agentEditorUi = new AgentEditorUi(this, actions);
        agentEditorUi.createContent(this.form, this.formToolkit);
        agentEditorUi.refresh(() -> {
            this.stackLayout.topControl.dispose();
            this.stackLayout.topControl = this.form;
            this.parentComposite.layout();
        });
    }
}

