/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.raweditor.internal;

import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.openjdk.jmc.console.agent.raweditor.internal.ColorManager;
import org.openjdk.jmc.console.agent.raweditor.internal.NonRuleBasedDamagerRepairer;
import org.openjdk.jmc.console.agent.raweditor.internal.XmlColorConstants;
import org.openjdk.jmc.console.agent.raweditor.internal.XmlDoubleClickStrategy;
import org.openjdk.jmc.console.agent.raweditor.internal.XmlScanner;
import org.openjdk.jmc.console.agent.raweditor.internal.XmlTagScanner;

public class XmlConfiguration
extends SourceViewerConfiguration {
    private XmlDoubleClickStrategy doubleClickStrategy;
    private XmlTagScanner tagScanner;
    private XmlScanner scanner;
    private ColorManager colorManager;

    public XmlConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new XmlDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected XmlScanner getXMLScanner() {
        if (this.scanner == null) {
            this.scanner = new XmlScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(XmlColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    protected XmlTagScanner getXMLTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new XmlTagScanner(this.colorManager);
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(XmlColorConstants.TAG))));
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(XmlColorConstants.XML_COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__xml_comment");
        return reconciler;
    }
}

