/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.wizards;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.openjdk.jmc.common.jvm.JVMDescriptor;
import org.openjdk.jmc.console.agent.AgentJmxHelper;
import org.openjdk.jmc.console.agent.editor.AgentEditorInput;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.openjdk.jmc.console.agent.wizards.StartAgentWizardPage;
import org.openjdk.jmc.ui.misc.DialogToolkit;

public class StartAgentWizard
extends Wizard {
    private final AgentJmxHelper helper;
    private final StartAgentWizardPage startAgentWizardPage;

    public StartAgentWizard(AgentJmxHelper helper) {
        this.helper = helper;
        this.startAgentWizardPage = new StartAgentWizardPage(helper);
        this.setHelpAvailable(false);
        WizardDialog.setDialogHelpAvailable((boolean)false);
    }

    public boolean canFinish() {
        return !this.startAgentWizardPage.getAgentJarPath().isEmpty();
    }

    public boolean performFinish() {
        JVMDescriptor targetJvm = this.startAgentWizardPage.getTargetJvm();
        String agentJarPath = this.startAgentWizardPage.getAgentJarPath();
        String agentXmlPath = this.startAgentWizardPage.getAgentXmlPath();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            VirtualMachine vm = VirtualMachine.attach("" + targetJvm.getPid());
            this.loadAgent(vm, agentJarPath, agentXmlPath);
            AgentEditorInput ei = new AgentEditorInput(this.helper.getServerHandle(), this.helper.getConnectionHandle(), this.helper);
            window.getActivePage().openEditor((IEditorInput)ei, "org.openjdk.jmc.console.agent.editor.AgentEditor", true);
        }
        catch (IllegalArgumentException e) {
            DialogToolkit.showException((Shell)window.getShell(), (String)Messages.StartAgentWizard_MESSAGE_FAILED_TO_START_AGENT, (String)Messages.StartAgentWizard_MESSAGE_INVALID_AGENT_CONFIG, (Throwable)e);
            return false;
        }
        catch (AgentLoadException e) {
            DialogToolkit.showException((Shell)window.getShell(), (String)Messages.StartAgentWizard_MESSAGE_FAILED_TO_START_AGENT, (String)Messages.StartAgentWizard_MESSAGE_FAILED_TO_LOAD_AGENT, (Throwable)e);
            return false;
        }
        catch (AttachNotSupportedException | IOException e) {
            DialogToolkit.showException((Shell)window.getShell(), (String)Messages.StartAgentWizard_MESSAGE_FAILED_TO_START_AGENT, (String)Messages.StartAgentWizard_MESSAGE_UNEXPECTED_ERROR_HAS_OCCURRED, (Throwable)e);
            return false;
        }
        catch (AgentInitializationException e) {
            DialogToolkit.showException((Shell)window.getShell(), (String)Messages.StartAgentWizard_MESSAGE_FAILED_TO_START_AGENT, (String)Messages.StartAgentWizard_MESSAGE_ACCESS_TO_UNSAFE_REQUIRED, (Throwable)e);
            return false;
        }
        catch (PartInitException e) {
            DialogToolkit.showException((Shell)window.getShell(), (String)Messages.StartAgentWizard_MESSAGE_FAILED_TO_OPEN_AGENT_EDITOR, (String)Messages.StartAgentWizard_MESSAGE_UNEXPECTED_ERROR_HAS_OCCURRED, (Throwable)e);
            return false;
        }
        return true;
    }

    private void loadAgent(VirtualMachine vm, String agentJar, String xmlPath) throws IOException, AgentLoadException, AgentInitializationException {
        if (agentJar.isEmpty() || Files.notExists(Paths.get(agentJar, new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("the Agent JAR path does exists");
        }
        if (!xmlPath.isEmpty() && Files.notExists(Paths.get(xmlPath, new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("the Agent configuration path does exists");
        }
        vm.loadAgent(agentJar, xmlPath);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.startAgentWizardPage);
    }
}

