/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.internal;

import java.util.Properties;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadata;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.common.subscription.IMRITransformation;
import org.openjdk.jmc.rjmx.common.subscription.MRI;
import org.openjdk.jmc.rjmx.subscription.internal.MRITransformationToolkit;

public abstract class AbstractSingleMRITransformation
implements IMRITransformation {
    private static final String ATTRIBUTE_PROPERTY = "attribute";
    private static final String DISPLAY_NAME_PROPERTY = "displayName";
    private Properties m_transformationProperties;
    private MRI m_attribute;

    public void setProperties(Properties properties) {
        this.m_transformationProperties = properties;
        this.m_attribute = MRI.createFromQualifiedName((String)this.m_transformationProperties.getProperty(ATTRIBUTE_PROPERTY));
    }

    public MRI[] getAttributes() {
        return new MRI[]{this.m_attribute};
    }

    public void extendMetadata(IMRIMetadataService metadataService, IMRIMetadata metadata) {
        MRITransformationToolkit.forwardMetadata((IMRIMetadataService)metadataService, (MRI)metadata.getMRI(), (IMRIMetadata)metadataService.getMetadata(this.m_attribute), (String)this.getDisplayNamePattern());
    }

    protected String getDisplayNamePattern() {
        return this.m_transformationProperties.getProperty(DISPLAY_NAME_PROPERTY);
    }

    protected Number subtract(Number minuend, Number subtrahend) {
        if (!minuend.getClass().equals(subtrahend.getClass())) {
            throw new IllegalArgumentException("Different type classes!");
        }
        if (minuend instanceof Integer) {
            return minuend.intValue() - subtrahend.intValue();
        }
        if (minuend instanceof Long) {
            return minuend.longValue() - subtrahend.longValue();
        }
        if (minuend instanceof Byte) {
            return (byte)(minuend.intValue() - subtrahend.intValue());
        }
        if (minuend instanceof Short) {
            return (short)(minuend.intValue() - subtrahend.intValue());
        }
        if (minuend instanceof Float) {
            return Float.valueOf(minuend.floatValue() - subtrahend.floatValue());
        }
        return minuend.doubleValue() - subtrahend.doubleValue();
    }
}

