/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.internal;

import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.rjmx.common.subscription.MRIValueEvent;
import org.openjdk.jmc.rjmx.subscription.internal.AbstractSingleMRITransformation;

public class AverageTransformation
extends AbstractSingleMRITransformation {
    private int m_maxTerms;
    private int m_terms = 0;
    private Double m_average = null;

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        this.m_maxTerms = Integer.parseInt(properties.getProperty("terms", "30"));
    }

    public Object createSubscriptionValue(MRIValueEvent event) {
        if (event.getValue() instanceof Number) {
            double eventValue = ((Number)event.getValue()).doubleValue();
            if (this.m_average != null) {
                if (this.m_terms < this.m_maxTerms) {
                    ++this.m_terms;
                }
                double portion = 1.0 / (double)this.m_terms;
                this.m_average = portion * eventValue + (1.0 - portion) * this.m_average;
            } else {
                this.m_average = eventValue;
                this.m_terms = 1;
            }
        }
        return this.m_average == null ? NO_VALUE : this.m_average;
    }

    @Override
    protected String getDisplayNamePattern() {
        return NLS.bind((String)super.getDisplayNamePattern(), (Object)this.m_maxTerms);
    }
}

