/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.triggers.extension.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;

public class ExtensionLoader<T> {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.rjmx.triggers.extension.internal");
    private final String m_extensionPoint;
    private final String m_extensionName;
    private final HashMap<String, IConfigurationElement> m_extensions = new HashMap();
    private final ArrayList<T> m_prototypes = new ArrayList();

    public ExtensionLoader(String extensionPoint, String extensionName) {
        this.m_extensionPoint = extensionPoint;
        this.m_extensionName = extensionName;
        this.load();
    }

    public String getExtensionName() {
        return this.m_extensionName;
    }

    public String getExtensionPointId() {
        return this.m_extensionPoint;
    }

    protected void load() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint exPoint = registry.getExtensionPoint(this.getExtensionPointId());
        if (exPoint == null) {
            return;
        }
        try {
            IExtension[] ext;
            IExtension[] iExtensionArray = ext = exPoint.getExtensions();
            int n = ext.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] element;
                IExtension element2 = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = element = element2.getConfigurationElements();
                int n3 = element.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element3 = iConfigurationElementArray[n4];
                    if (element3.getName().equalsIgnoreCase(this.getExtensionName())) {
                        this.initExtension(element3);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (InvalidRegistryObjectException iroe) {
            LOGGER.log(Level.SEVERE, "Extension point not valid.", iroe);
        }
    }

    public IConfigurationElement getConfigElement(String className) {
        return this.m_extensions.get(className);
    }

    public void initExtension(IConfigurationElement element) {
        try {
            Object prototype = element.createExecutableExtension("class");
            String className = element.getAttribute("class");
            this.m_extensions.put(className, element);
            this.m_prototypes.add(prototype);
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize extension", e);
        }
    }

    public Collection<T> getPrototypes() {
        return this.m_prototypes;
    }
}

