/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.attach;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AttachToolkit {
    private static final boolean isLocalAttachAvailable;
    private static final Class<?> connectorAddressLink;
    private static final Logger LOGGER;

    static {
        boolean available;
        LOGGER = Logger.getLogger("org.openjdk.jmc.attach");
        Class<?> cal = null;
        try {
            Class.forName("com.sun.tools.attach.VirtualMachine");
            Class.forName("sun.tools.attach.HotSpotVirtualMachine");
            Class.forName("sun.jvmstat.monitor.MonitorException");
            cal = AttachToolkit.lookupConnectorAddressLink();
            available = true;
        }
        catch (Throwable t) {
            available = false;
            LOGGER.log(Level.FINE, "Attach functionality will not be enabled.", t);
        }
        isLocalAttachAvailable = available;
        connectorAddressLink = cal;
    }

    public static boolean isLocalAttachAvailable() {
        return isLocalAttachAvailable;
    }

    private static Class<?> lookupConnectorAddressLink() throws Throwable {
        try {
            return Class.forName("jdk.internal.agent.ConnectorAddressLink");
        }
        catch (Throwable t) {
            LOGGER.log(Level.INFO, "Could not load ConnectorAddressLink class, probably because JMC is run with Java 8", t);
            return Class.forName("sun.management.ConnectorAddressLink");
        }
    }

    public static String importFromPid(Integer pid) {
        try {
            Method importFrom = connectorAddressLink.getMethod("importFrom", Integer.TYPE);
            return (String)importFrom.invoke(null, pid);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Throwable t) {
            LOGGER.log(Level.WARNING, "Could not get connector address for pid", t);
        }
        return null;
    }
}

