/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.ui.misc.SWTColorToolkit;

public abstract class BackgroundFractionDrawer
implements Listener {
    private static final Color BG = SWTColorToolkit.getColor(new RGB(200, 100, 100));

    protected void draw(double fraction, Event event) {
        if (fraction > 0.0 && fraction <= 1.0) {
            event.gc.setBackground(BG);
            event.gc.fillRectangle(event.x, event.y, (int)((double)event.width * fraction), event.height);
            event.detail &= 0xFFFFFFF7;
        }
    }

    public static <T> Listener unchecked(final Function<T, IQuantity> func) {
        return new BackgroundFractionDrawer(){

            public void handleEvent(Event event) {
                IQuantity q = (IQuantity)func.apply(event.item.getData());
                if (q != null) {
                    if (q.getType() == UnitLookup.NUMBER) {
                        this.draw(q.doubleValueIn((IUnit)UnitLookup.NUMBER_UNITY), event);
                    } else if (q.getType() == UnitLookup.PERCENTAGE) {
                        this.draw(q.doubleValueIn((IUnit)UnitLookup.PERCENT_UNITY), event);
                    }
                }
            }
        };
    }

    public static <T> Listener unchecked(final ToDoubleFunction<T> func) {
        return new BackgroundFractionDrawer(){

            public void handleEvent(Event event) {
                this.draw(func.applyAsDouble(event.item.getData()), event);
            }
        };
    }
}

