/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import java.util.Arrays;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    private static final int ALPHA_REDUCTION = 2;
    private final ImageDescriptor base;
    private final boolean reduceAlpha;
    private final ImageDescriptor[] overlays;

    public OverlayImageDescriptor(ImageDescriptor base, boolean reduceAlpha, ImageDescriptor ... overlays) {
        this.base = base;
        this.overlays = overlays;
        this.reduceAlpha = reduceAlpha;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData id = this.base.getImageData(100);
        if (this.reduceAlpha) {
            int x = 0;
            while (x < id.width) {
                int y = 0;
                while (y < id.height) {
                    id.setAlpha(x, y, id.getAlpha(x, y) / 2);
                    ++y;
                }
                ++x;
            }
        }
        this.drawImage(zoom -> zoom == 100 ? id : null, 0, 0);
        ImageDescriptor[] imageDescriptorArray = this.overlays;
        int n = this.overlays.length;
        int n2 = 0;
        while (n2 < n) {
            ImageDescriptor overlay = imageDescriptorArray[n2];
            if (overlay != null) {
                this.drawImage(zoom -> overlay.getImageData(zoom), 0, 0);
            }
            ++n2;
        }
    }

    protected Point getSize() {
        ImageData baseData = this.base.getImageData(100);
        return new Point(baseData.width, baseData.height);
    }

    public int hashCode() {
        return this.base.hashCode() + Arrays.hashCode(this.overlays);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OverlayImageDescriptor)) {
            return false;
        }
        OverlayImageDescriptor other = (OverlayImageDescriptor)((Object)obj);
        return other.reduceAlpha == this.reduceAlpha && other.base.equals(this.base) && Arrays.equals(other.overlays, this.overlays);
    }
}

