/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import org.eclipse.swt.custom.SashForm;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.util.StateToolkit;

public class PersistableSashForm {
    private static final String ATTRIBUTE_WEIGHTS = "weights";
    private static final String HORIZONTAL = "horizontal";

    public static void loadState(SashForm form, IState sashState) {
        if (sashState != null) {
            Boolean horizontal;
            int[] weightInts;
            String weights = sashState.getAttribute(ATTRIBUTE_WEIGHTS);
            if (weights != null && (weightInts = PersistableSashForm.parseIntArray(weights)) != null && weightInts.length == form.getWeights().length) {
                form.setWeights(weightInts);
            }
            form.setOrientation(Boolean.TRUE.equals(horizontal = StateToolkit.readBoolean((IState)sashState, (String)HORIZONTAL, null)) ? 256 : 512);
        }
    }

    public static void saveState(SashForm form, IWritableState sashState) {
        int[] weights = form.getWeights();
        if (weights.length >= 1) {
            sashState.putString(ATTRIBUTE_WEIGHTS, PersistableSashForm.formatIntArray(weights));
            if (form.getOrientation() == 256) {
                StateToolkit.writeBoolean((IWritableState)sashState, (String)HORIZONTAL, (Boolean)true);
            }
        }
    }

    private static int[] parseIntArray(String str) {
        String[] strArray = str.split(",");
        int[] intArray = new int[strArray.length];
        try {
            int i = 0;
            while (i < strArray.length) {
                intArray[i] = Integer.parseInt(strArray[i]);
                ++i;
            }
            return intArray;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static String formatIntArray(int[] intArray) {
        if (intArray.length == 0) {
            return "";
        }
        StringBuffer str = new StringBuffer(String.valueOf(intArray[0]));
        int i = 1;
        while (i < intArray.length) {
            str.append("," + intArray[i]);
            ++i;
        }
        return str.toString();
    }
}

