/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionProvider
implements ISelectionProvider {
    private final ListenerList<ISelectionChangedListener> m_listeners = new ListenerList();
    private ISelection m_selection = StructuredSelection.EMPTY;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_listeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return this.m_selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_listeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        this.m_selection = selection != null ? selection : StructuredSelection.EMPTY;
        this.fireSelectionChanges();
    }

    private void fireSelectionChanges() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this.m_listeners) {
            listener.selectionChanged(event);
        }
    }
}

