/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemToolkit;
import org.openjdk.jmc.common.util.FormatToolkit;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.common.util.XmlToolkit;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.charts.IChartInfoVisitor;
import org.openjdk.jmc.ui.common.util.AdapterUtil;
import org.openjdk.jmc.ui.misc.SWTColorToolkit;

public class ChartToolTipProvider
implements IChartInfoVisitor {
    private static final int MAXIMUM_VISIBLE_STACK_TRACE_ELEMENTS = 10;
    private static final String INDENT_4_NBSP = "&#160;&#160;&#160;&#160;";
    private static final String INITIAL_HTML = "<form>";
    protected StringBuilder text = new StringBuilder("<form>");
    private final Map<String, Image> imageMap = new HashMap<String, Image>();
    private int colorNum;
    protected int bulletIndent;
    protected String lastAt;

    public String getHTML() {
        if (this.text.length() <= INITIAL_HTML.length()) {
            return null;
        }
        this.text.append("</form>");
        return this.text.toString();
    }

    public Map<String, Image> getImages() {
        return this.imageMap;
    }

    protected Stream<IAttribute<?>> getAttributeStream(IType<IItem> type) {
        return type.getAttributes().stream();
    }

    public boolean enterScope(String context, boolean fullyShown) {
        if (!fullyShown) {
            this.text.append("<p>").append(ChartToolTipProvider.htmlify(context)).append("</p>");
            this.bulletIndent += 16;
            return true;
        }
        return false;
    }

    public void leaveScope() {
        this.bulletIndent -= 16;
    }

    public void hover(Object data) {
    }

    protected String format(IDisplayable value) {
        if (value != null) {
            String auto = value.displayUsing("auto");
            return ChartToolTipProvider.htmlify(auto);
        }
        return Messages.N_A;
    }

    protected void appendTagLI(Color color) {
        if (color != null) {
            this.imageMap.put("color." + this.colorNum, SWTColorToolkit.getColorThumbnail((RGB)SWTColorToolkit.asRGB((Color)color)));
            this.text.append("<li style='image' value='color.").append(this.colorNum).append("' ");
            ++this.colorNum;
        } else {
            this.text.append("<li ");
        }
        this.text.append("bindent='0'> ");
    }

    protected void appendTitle(String title) {
        this.text.append("<p><b>").append(title).append("</b></p>");
    }

    protected void appendAtIfNew(IDisplayable newAt) {
        String newAtAsString = this.format(newAt);
        if (!newAtAsString.equals(this.lastAt)) {
            this.text.append("<p><span nowrap='true'>At ").append(newAtAsString).append(":<br/></span></p>");
            this.lastAt = newAtAsString;
        }
    }

    public void visit(IChartInfoVisitor.IPoint point) {
        this.appendAtIfNew(point.getX());
        this.appendTagLI(point.getColor());
        String name = point.getName();
        this.text.append("<span nowrap='true'>");
        if (name != null) {
            this.text.append(ChartToolTipProvider.htmlify(name)).append(" = ");
        }
        this.text.append(this.format(point.getY()));
        this.text.append("</span></li>");
    }

    public void visit(IChartInfoVisitor.IBucket bucket) {
        this.appendAtIfNew(bucket.getRange());
        this.appendTagLI(bucket.getColor());
        this.text.append("<span nowrap='true'>");
        String name = bucket.getName();
        if (name != null) {
            this.text.append(ChartToolTipProvider.htmlify(name));
            this.text.append(" [").append(this.format(bucket.getWidth())).append("] = ");
        } else {
            this.text.append("[").append(this.format(bucket.getWidth())).append("]: ");
        }
        this.text.append(this.format(bucket.getY()));
        this.text.append("</span></li>");
    }

    public void visit(IChartInfoVisitor.ISpan span) {
        IType type;
        if (span.getDescription() != null) {
            this.appendTitle(span.getDescription());
        }
        this.appendAtIfNew(span.getRange());
        this.appendTagLI(span.getColor());
        Object payload = span.getPayload();
        IItem item = (IItem)AdapterUtil.getAdapter((Object)payload, IItem.class);
        if (payload instanceof IDisplayable) {
            this.text.append("<span nowrap='true'>");
            this.text.append(this.format((IDisplayable)payload)).append(": ");
        } else if (item != null) {
            type = ItemToolkit.getItemType((IItem)item);
            this.text.append("<b>").append(ChartToolTipProvider.htmlify(type.getName())).append("</b><span nowrap='true'>: ");
        }
        this.text.append(this.format(span.getWidth()));
        this.text.append("</span></li>");
        if (item != null) {
            type = ItemToolkit.getItemType((IItem)item);
            IMCStackTrace trace = null;
            Iterator attributes = this.getAttributeStream((IType<IItem>)type).iterator();
            while (attributes.hasNext()) {
                IAttribute attribute = (IAttribute)attributes.next();
                if (attribute.equals(JfrAttributes.EVENT_STACKTRACE)) {
                    trace = (IMCStackTrace)JfrAttributes.EVENT_STACKTRACE.getAccessor(type).getMember((Object)item);
                    continue;
                }
                this.text.append("<p vspace='false'><span nowrap='true'>");
                this.text.append(ChartToolTipProvider.htmlify(attribute.getName())).append(": ");
                Object value = attribute.getAccessor(type).getMember((Object)item);
                String valueString = TypeHandling.getValueString((Object)value);
                this.text.append(ChartToolTipProvider.htmlify(valueString));
                this.text.append("</span></p>");
            }
            if (trace != null) {
                this.text.append("<p vspace='false'/>");
                this.text.append("<p vspace='false'>");
                this.text.append(ChartToolTipProvider.htmlify(JfrAttributes.EVENT_STACKTRACE.getName())).append(":<br/>");
                this.appendStackTrace(trace, true, false, true, true, true, false);
                this.text.append("</p>");
            }
        }
    }

    private void appendStackTrace(IMCStackTrace trace, boolean showReturnValue, boolean showReturnValuePackage, boolean showClassName, boolean showClassPackageName, boolean showArguments, boolean showArgumentsPackage) {
        String indent = "    ";
        String lineSeparator = System.getProperty("line.separator");
        String stackTraceString = FormatToolkit.getHumanReadable((IMCStackTrace)trace, (boolean)showReturnValue, (boolean)showReturnValuePackage, (boolean)showClassName, (boolean)showClassPackageName, (boolean)showArguments, (boolean)showArgumentsPackage, (int)10, (String)indent, null, (String)lineSeparator);
        stackTraceString = ChartToolTipProvider.htmlify(stackTraceString);
        stackTraceString = stackTraceString.replace(indent, INDENT_4_NBSP);
        stackTraceString = stackTraceString.replace(lineSeparator, "<br/>");
        this.text.append(stackTraceString);
    }

    public void visit(IChartInfoVisitor.ITick tick) {
        this.text.append("<p><span nowrap='true'>");
        this.text.append(ChartToolTipProvider.htmlify(tick.getValue().displayUsing("verbose")));
        this.text.append("</span><br/></p>");
    }

    private static String htmlify(String text) {
        return XmlToolkit.escapeTagContent((String)text);
    }

    public void visit(IChartInfoVisitor.ILane lane) {
        this.text.append("<p><span nowrap='true'>");
        this.text.append(ChartToolTipProvider.htmlify(NLS.bind((String)Messages.ChartToolTipProvider_CAPTION_NAME, (Object)lane.getLaneName())));
        this.text.append("</span><br/><span nowrap='true'>");
        if (lane.getLaneDescription() != null && !lane.getLaneDescription().isEmpty()) {
            this.text.append(ChartToolTipProvider.htmlify(NLS.bind((String)Messages.ChartToolTipProvider_CAPTION_DESCRIPTION, (Object)lane.getLaneDescription())));
        }
        this.text.append("</span></p>");
    }
}

