/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.util.List;
import java.util.Optional;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FilterComponent;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.ActionUiToolkit;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.PersistableSashForm;

abstract class ChartAndTableUI
implements IPageUI {
    private static final String SASH = "sash";
    private static final String TABLE = "table";
    private static final String CHART = "chart";
    private static final String SELECTED = "selected";
    private static final int X_OFFSET = 180;
    private IItemFilter pageFilter;
    protected StreamModel model;
    protected CheckboxTableViewer chartLegend;
    protected Form form;
    protected Composite chartContainer;
    protected ChartCanvas chartCanvas;
    protected FilterComponent tableFilterComponent;
    protected ItemHistogram table;
    protected SashForm sash;
    private IPageContainer pageContainer;
    protected List<IAction> allChartSeriesActions;
    private IItemCollection selectionItems;
    private IRange<IQuantity> timeRange;
    protected XYChart chart;
    protected FlavorSelector flavorSelector;

    ChartAndTableUI(IItemFilter pageFilter, StreamModel model, Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state, String sectionTitle, IItemFilter tableFilter, Image icon, FlavorSelector.FlavorSelectorState flavorSelectorState, IAttribute<?> classifier) {
        this.init(pageFilter, model, parent, toolkit, pageContainer, state, sectionTitle, tableFilter, icon, flavorSelectorState, classifier);
    }

    protected void init(IItemFilter pageFilter, StreamModel model, Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state, String sectionTitle, IItemFilter tableFilter, Image icon, FlavorSelector.FlavorSelectorState flavorSelectorState, IAttribute<?> classifier) {
        String legendSelection;
        this.pageFilter = pageFilter;
        this.model = model;
        this.pageContainer = pageContainer;
        this.form = DataPageToolkit.createForm(parent, toolkit, sectionTitle, icon);
        this.sash = new SashForm(this.form.getBody(), 512);
        toolkit.adapt((Composite)this.sash);
        this.table = this.buildHistogram((Composite)this.sash, state.getChild(TABLE), classifier);
        MCContextMenuManager mm = MCContextMenuManager.create((Control)this.table.getManager().getViewer().getControl());
        ColumnMenusFactory.addDefaultMenus((ColumnManager)this.table.getManager(), (MCContextMenuManager)mm);
        this.table.getManager().getViewer().addSelectionChangedListener(e -> this.buildChart());
        this.table.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(this.table.getSelection().getItems()));
        SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.table, NLS.bind((String)Messages.ChartAndTableUI_HISTOGRAM_SELECTION, (Object)sectionTitle), (IContributionManager)mm);
        this.tableFilterComponent = FilterComponent.createFilterComponent(this.table.getManager().getViewer().getControl(), this.table.getManager(), tableFilter, model.getItems().apply(pageFilter), pageContainer.getSelectionStore()::getSelections, this::onFilterChange);
        mm.add(this.tableFilterComponent.getShowFilterAction());
        mm.add(this.tableFilterComponent.getShowSearchAction());
        this.chartContainer = toolkit.createComposite((Composite)this.sash);
        this.chartContainer.setLayout((Layout)new GridLayout(2, false));
        this.chartCanvas = new ChartCanvas(this.chartContainer);
        this.chartCanvas.setLayoutData((Object)new GridData(4, 4, true, true));
        this.allChartSeriesActions = this.initializeChartConfiguration(state);
        IState chartState = state.getChild(CHART);
        ActionToolkit.loadCheckState((IState)chartState, this.allChartSeriesActions.stream());
        this.chartLegend = ActionUiToolkit.buildCheckboxViewer((Composite)this.chartContainer, this.allChartSeriesActions.stream());
        GridData gd = new GridData(4, 4, false, true);
        gd.widthHint = 180;
        this.chartLegend.getControl().setLayoutData((Object)gd);
        PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(SASH));
        DataPageToolkit.createChartTimestampTooltip(this.chartCanvas);
        this.chart = new XYChart(pageContainer.getRecordingRange(), RendererToolkit.empty(), 180);
        DataPageToolkit.setChart(this.chartCanvas, this.chart, pageContainer::showSelection);
        SelectionStoreActionToolkit.addSelectionStoreRangeActions(pageContainer.getSelectionStore(), this.chart, (IAttribute<IRange<IQuantity>>)JfrAttributes.LIFETIME, NLS.bind((String)Messages.ChartAndTableUI_TIMELINE_SELECTION, (Object)this.form.getText()), (IContributionManager)this.chartCanvas.getContextMenu());
        this.buildChart();
        if (chartState != null && (legendSelection = chartState.getAttribute(SELECTED)) != null) {
            this.allChartSeriesActions.stream().filter(ia -> legendSelection.equals(ia.getId())).findFirst().ifPresent(a -> this.chartLegend.setSelection((ISelection)new StructuredSelection(a)));
        }
        this.flavorSelector = FlavorSelector.itemsWithTimerange(this.form, pageFilter, model.getItems(), pageContainer, this::onFlavorSelected, this::onSetRange, flavorSelectorState);
    }

    protected void onFilterChange(IItemFilter filter) {
        IItemCollection items = this.getItems();
        if (this.tableFilterComponent.isVisible()) {
            this.table.show(items.apply(filter));
            this.tableFilterComponent.setColor(this.table.getAllRows().getRowCount());
        } else {
            this.table.show(items);
        }
    }

    public void saveTo(IWritableState writableState) {
        PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)writableState.createChild(SASH));
        this.table.getManager().getSettings().saveState(writableState.createChild(TABLE));
        IWritableState chartState = writableState.createChild(CHART);
        ActionToolkit.saveCheckState((IWritableState)chartState, this.allChartSeriesActions.stream());
        Object legendSelection = ((IStructuredSelection)this.chartLegend.getSelection()).getFirstElement();
        if (legendSelection != null) {
            chartState.putString(SELECTED, ((IAction)legendSelection).getId());
        }
    }

    public Form getComponent() {
        return this.form;
    }

    private void onSetRange(Boolean useRange) {
        IRange<IQuantity> range = useRange != false ? this.timeRange : this.pageContainer.getRecordingRange();
        this.chart.setVisibleRange((IQuantity)range.getStart(), (IQuantity)range.getEnd());
        this.buildChart();
    }

    private void onFlavorSelected(IItemCollection items, IRange<IQuantity> timeRange) {
        this.selectionItems = items;
        this.timeRange = timeRange;
        this.table.show(this.getItems());
        Object[] tableInput = (Object[])this.table.getManager().getViewer().getInput();
        if (this.selectionItems != null && tableInput != null) {
            this.table.getManager().getViewer().setSelection((ISelection)new StructuredSelection(tableInput));
        } else {
            this.table.getManager().getViewer().setSelection(null);
        }
        this.chart.setVisibleRange((IQuantity)timeRange.getStart(), (IQuantity)timeRange.getEnd());
    }

    protected void buildChart() {
        IXDataRenderer rendererRoot = this.getChartRenderer(this.getItems(), this.table.getSelection());
        this.chartCanvas.replaceRenderer(rendererRoot);
    }

    private IItemCollection getItems() {
        return this.selectionItems != null ? this.selectionItems.apply(this.pageFilter) : this.model.getItems().apply(this.pageFilter);
    }

    protected boolean isAttributeEnabled(IAttribute<IQuantity> attr) {
        Optional<IAction> action = this.allChartSeriesActions.stream().filter(a -> attr.getIdentifier().equals(a.getId())).findAny();
        return action.isPresent() && action.get().isChecked();
    }

    protected abstract ItemHistogram buildHistogram(Composite var1, IState var2, IAttribute<?> var3);

    protected abstract IXDataRenderer getChartRenderer(IItemCollection var1, ItemHistogram.HistogramSelection var2);

    protected abstract List<IAction> initializeChartConfiguration(IState var1);
}

