/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders.MethodProfilingDataProvider;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.ItemRow;
import org.openjdk.jmc.flightrecorder.ui.common.PairBucketBuilder;
import org.openjdk.jmc.flightrecorder.ui.common.ThreadGraphLanes;
import org.openjdk.jmc.flightrecorder.ui.common.TypeLabelProvider;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.pages.ChartAndTableUI;
import org.openjdk.jmc.ui.OrientationAction;
import org.openjdk.jmc.ui.charts.AWTChartToolkit;
import org.openjdk.jmc.ui.charts.IQuantitySeries;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.charts.XYDataRenderer;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.SWTColorToolkit;

public class JavaApplicationPage
extends AbstractDataPage {
    private static final Color EXCEPTIONS_COLOR = TypeLabelProvider.getColor("jdk.JavaExceptionThrow");
    private static final AWTChartToolkit.IColorProvider<IQuantity> PROFILING_COLOR = new AWTChartToolkit.IColorProvider<IQuantity>(){

        public Color getColor(IQuantity balance) {
            double fraction = balance == null ? 0.0 : Math.max(0.0, Math.min(balance.doubleValue(), 1.0));
            float hue = 0.12f - (float)(fraction * 0.1);
            float saturation = fraction < 0.5 ? 0.35f + (float)fraction : 0.85f;
            return Color.getHSBColor(hue, saturation, 0.95f);
        }
    };
    private static final ImageDescriptor PROFILING_LEGEND_ICON = SWTColorToolkit.createGradientThumbnail((RGB)SWTColorToolkit.asRGB((Color)PROFILING_COLOR.getColor((Object)UnitLookup.NUMBER_UNITY.quantity(1L))), (RGB)SWTColorToolkit.asRGB((Color)PROFILING_COLOR.getColor((Object)UnitLookup.NUMBER_UNITY.quantity(0L))), (boolean)true);
    private static final IItemFilter ALL_THREAD_EVENTS = ItemFilters.hasAttribute((ICanonicalAccessorFactory)JfrAttributes.EVENT_THREAD);
    private static final String THREAD_LANE = "threadLane";
    private static final String PROFILING_COUNT_COL = "profilingCount";
    private static final String ALLOCATION_COL = "allocation";
    private static final String EXCEPTIONS_COL = "exceptions";
    private static final String THREAD_START_COL = "threadStart";
    private static final String THREAD_END_COL = "threadEnd";
    private static final String THREAD_DURATION_COL = "threadDuration";
    private static final String IO_TIME_COL = "ioTime";
    private static final String IO_COUNT_COL = "ioCount";
    private static final String BLOCKED_TIME_COL = "blockedTime";
    private static final String BLOCKED_COUNT_COL = "blockedCount";
    private static final String CLASSLOAD_COUNT_COL = "classloadingCount";
    private static final String CLASSLOAD_TIME_COL = "classloadingTime";
    private static final String APPLICATION_PAUSE_ID = "applicationPause";
    private static final String ACTIVITY_LANES_ID = "threadActivityLanes";
    private static final String PROFILING_PERCENTAGE_COL = "profilingCount.Percentage";
    private static final ItemHistogram.ItemHistogramBuilder HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private IRange<IQuantity> visibleRange;
    private IItemFilter tableFilter;
    private ColumnManager.SelectionState tableState;
    private FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        HISTOGRAM.addColumn(JdkAttributes.EVENT_THREAD_GROUP_NAME);
        HISTOGRAM.addColumn(JdkAttributes.EVENT_THREAD_ID);
        HISTOGRAM.addColumn(PROFILING_COUNT_COL, JdkAggregators.EXECUTION_SAMPLE_COUNT);
        HISTOGRAM.addColumn(ALLOCATION_COL, JdkAggregators.ALLOCATION_TOTAL);
        HISTOGRAM.addColumn(IO_TIME_COL, JdkAggregators.TOTAL_IO_TIME);
        HISTOGRAM.addColumn(IO_COUNT_COL, JdkAggregators.TOTAL_IO_COUNT);
        HISTOGRAM.addColumn(BLOCKED_TIME_COL, JdkAggregators.TOTAL_BLOCKED_TIME);
        HISTOGRAM.addColumn(BLOCKED_COUNT_COL, JdkAggregators.TOTAL_BLOCKED_COUNT);
        HISTOGRAM.addColumn(CLASSLOAD_COUNT_COL, JdkAggregators.CLASS_LOADING_COUNT);
        HISTOGRAM.addColumn(CLASSLOAD_TIME_COL, JdkAggregators.CLASS_LOADING_TIME_SUM);
        HISTOGRAM.addColumn(EXCEPTIONS_COL, JdkAggregators.THROWABLES_COUNT);
        HISTOGRAM.addColumn(THREAD_START_COL, Aggregators.min((String)Messages.JavaApplicationPage_COLUMN_THREAD_START, (String)Messages.JavaApplicationPage_COLUMN_THREAD_START_DESC, (String)"jdk.ThreadStart", (IAttribute)JfrAttributes.EVENT_TIMESTAMP));
        HISTOGRAM.addColumn(THREAD_END_COL, Aggregators.max((String)Messages.JavaApplicationPage_COLUMN_THREAD_END, (String)Messages.JavaApplicationPage_COLUMN_THREAD_END_DESC, (String)"jdk.ThreadEnd", (IAttribute)JfrAttributes.EVENT_TIMESTAMP));
        HISTOGRAM.addColumn(JdkAttributes.EVENT_THREAD_ID);
        HISTOGRAM.addColumn(THREAD_DURATION_COL, ic -> {
            IQuantity threadStart = (IQuantity)ic.apply(ItemFilters.type((String)"jdk.ThreadStart")).getAggregate(Aggregators.min((IAttribute)JfrAttributes.EVENT_TIMESTAMP));
            IQuantity threadEnd = (IQuantity)ic.apply(ItemFilters.type((String)"jdk.ThreadEnd")).getAggregate(Aggregators.max((IAttribute)JfrAttributes.EVENT_TIMESTAMP));
            if (threadStart != null && threadEnd != null) {
                return threadEnd.subtract(threadStart);
            }
            return null;
        }, Messages.JavaApplicationPage_COLUMN_THREAD_DURATION, Messages.JavaApplicationPage_COLUMN_THREAD_DURATION_DESC);
        HISTOGRAM.addPercentageColumn(PROFILING_PERCENTAGE_COL, JdkAggregators.EXECUTION_SAMPLE_COUNT, Messages.JavaApplicationPage_COLUMN_THREAD_PERCENTAGE, Messages.JavaApplicationPage_COLUMN_THREAD_PERCENTAGE_DESC);
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new JavaApplicationUi(parent, toolkit, pageContainer, state);
    }

    public JavaApplicationPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
        this.visibleRange = editor.getRecordingRange();
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return ALL_THREAD_EVENTS;
    }

    private static String threadCount(int count) {
        switch (count) {
            case 0: {
                return "";
            }
            case 1: {
                return " (" + Messages.JavaApplicationPage_SELECTED_THREAD + ")";
            }
        }
        return NLS.bind((String)(" (" + Messages.JavaApplicationPage_SELECTED_THREADS + ")"), (Object)count);
    }

    public static class JavaApplicationPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.JavaApplicationPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/methodprofiling.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"java_application", "method_profiling"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new JavaApplicationPage(dpd, items, editor);
        }
    }

    private class JavaApplicationUi
    extends ChartAndTableUI {
        private static final String METHOD_PROFILING_TABLE_FILTER = "methodProfilingTableFilter";
        private IAction applicationPauseIdAction;
        private IAction profilingCountAction;
        private IAction allocationAction;
        private IAction exceptionsAction;
        private IAction threadActivityAction;
        private MCContextMenuManager mm;
        private ThreadGraphLanes lanes;

        JavaApplicationUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            super(ALL_THREAD_EVENTS, JavaApplicationPage.this.getDataSource(), parent, toolkit, pageContainer, state, JavaApplicationPage.this.getName(), JavaApplicationPage.this.tableFilter, JavaApplicationPage.this.getIcon(), JavaApplicationPage.this.flavorSelectorState, JfrAttributes.EVENT_THREAD);
            this.mm = (MCContextMenuManager)this.chartCanvas.getContextMenu();
            this.lanes.updateContextMenu(this.mm, false);
            this.lanes.updateContextMenu(MCContextMenuManager.create((Control)this.chartLegend.getControl()), true);
            this.buildChart();
            JavaApplicationPage.this.addResultActions(this.form);
            this.tableFilterComponent.loadState(state.getChild(METHOD_PROFILING_TABLE_FILTER));
            this.form.getToolBarManager().add(ActionToolkit.action(() -> this.lanes.openEditLanesDialog(this.mm, false), (String)Messages.ThreadsPage_EDIT_LANES, (ImageDescriptor)FlightRecorderUI.getDefault().getMCImageDescriptor("lanes_edit.gif")));
            this.form.getToolBarManager().add((IContributionItem)new Separator());
            OrientationAction.installActions((Form)this.form, (SashForm)this.sash);
            this.chart.addVisibleRangeListener(r -> {
                IRange iRange = JavaApplicationPage.this.visibleRange = r;
            });
            this.chart.setVisibleRange((IQuantity)JavaApplicationPage.this.visibleRange.getStart(), (IQuantity)JavaApplicationPage.this.visibleRange.getEnd());
            this.table.getManager().setSelectionState(JavaApplicationPage.this.tableState);
        }

        @Override
        protected ItemHistogram buildHistogram(Composite parent, IState state, IAttribute<?> classifier) {
            ItemHistogram build = HISTOGRAM.buildWithoutBorder(parent, classifier, TableSettings.forState((IState)state));
            return build;
        }

        @Override
        protected IXDataRenderer getChartRenderer(IItemCollection itemsInTable, ItemHistogram.HistogramSelection selection) {
            boolean useDefaultSelection;
            List<IXDataRenderer> rows = new ArrayList<IXDataRenderer>();
            IItemCollection allItems = JavaApplicationPage.this.getDataSource().getItems();
            DataPageToolkit.buildLinesRow(Messages.JavaApplicationPage_ROW_CPU_USAGE, Messages.JavaApplicationPage_ROW_CPU_USAGE_DESC, allItems, true, JdkQueries.CPU_USAGE_SIMPLE_QUERY, this::isAttributeEnabled, (IQuantity)UnitLookup.PERCENT.quantity(0L), (IQuantity)UnitLookup.PERCENT.quantity(100L)).ifPresent(rows::add);
            DataPageToolkit.buildLinesRow(Messages.JavaApplicationPage_ROW_HEAP_USAGE, JdkAttributes.HEAP_USED.getDescription(), allItems, false, JdkQueries.HEAP_SUMMARY, this::isAttributeEnabled, (IQuantity)UnitLookup.BYTE.quantity(0L), null).ifPresent(rows::add);
            IItemCollection selectedItems = selection.getRowCount() == 0 ? itemsInTable : selection.getItems();
            String threadCount = JavaApplicationPage.threadCount(selection.getRowCount());
            if (this.profilingCountAction.isChecked()) {
                IItemCollection profilingItems = selectedItems.apply(JdkFilters.EXECUTION_SAMPLE);
                IQuantitySeries<IQuantity[]> aggregatorSeries = PairBucketBuilder.aggregatorSeries(profilingItems, JdkAggregators.EXECUTION_SAMPLE_COUNT, MethodProfilingDataProvider.TOP_FRAME_BALANCE, (IAttribute<IQuantity>)JfrAttributes.END_TIME);
                XYDataRenderer renderer = new XYDataRenderer((IQuantity)UnitLookup.NUMBER_UNITY.quantity(0L), (IQuantity)UnitLookup.NUMBER_UNITY.quantity(100L), true, Messages.JavaApplicationPage_METHOD_PROFILING, JdkAggregators.EXECUTION_SAMPLE_COUNT.getDescription());
                renderer.addBarChart(Messages.JavaApplicationPage_METHOD_PROFILING, aggregatorSeries, PROFILING_COLOR);
                rows.add(new ItemRow(String.valueOf(Messages.JavaApplicationPage_METHOD_PROFILING) + threadCount, JdkAggregators.EXECUTION_SAMPLE_COUNT.getDescription(), (IXDataRenderer)renderer, profilingItems));
            }
            if (this.allocationAction.isChecked()) {
                rows.add(DataPageToolkit.buildTimestampHistogram(String.valueOf(Messages.JavaApplicationPage_ROW_ALLOCATION) + threadCount, JdkAggregators.ALLOCATION_TOTAL.getDescription(), selectedItems.apply(JdkFilters.ALLOC_ALL), JdkAggregators.ALLOCATION_TOTAL, DataPageToolkit.ALLOCATION_COLOR));
            }
            if (this.exceptionsAction.isChecked()) {
                rows.add(DataPageToolkit.buildTimestampHistogram(String.valueOf(JdkAggregators.THROWABLES_COUNT.getName()) + threadCount, JdkAggregators.THROWABLES_COUNT.getDescription(), selectedItems.apply(JdkFilters.THROWABLES), JdkAggregators.THROWABLES_COUNT, EXCEPTIONS_COLOR));
            }
            boolean bl = useDefaultSelection = rows.size() > 1;
            if (this.threadActivityAction.isChecked() && this.lanes.getLaneDefinitions().stream().anyMatch(a -> a.isEnabled()) && selection.getRowCount() > 0) {
                List threadRows = selection.getSelectedRows((thread, items) -> this.lanes.buildThreadRenderer(thread, (IItemCollection)items)).collect(Collectors.toList());
                double threadsWeight = Math.sqrt(threadRows.size()) * 0.15;
                double otherRowWeight = Math.max(threadsWeight * 0.1, (1.0 - threadsWeight) / (double)rows.size());
                List weights = Stream.concat(Stream.generate(() -> otherRowWeight).limit(rows.size()), Stream.of(Double.valueOf(threadsWeight))).collect(Collectors.toList());
                rows.add(RendererToolkit.uniformRows(threadRows));
                useDefaultSelection = true;
                rows = Arrays.asList(RendererToolkit.weightedRows(rows, weights));
            }
            IXDataRenderer rr = rows.size() == 1 ? (IXDataRenderer)rows.get(0) : RendererToolkit.uniformRows(rows);
            IXDataRenderer root = this.applicationPauseIdAction.isChecked() ? RendererToolkit.layers((IXDataRenderer[])new IXDataRenderer[]{DataPageToolkit.buildApplicationPauseRow(allItems), rr}) : rr;
            return useDefaultSelection ? new ItemRow(root, this.getDefaultSelection(selectedItems)) : root;
        }

        @Override
        protected List<IAction> initializeChartConfiguration(IState state) {
            this.applicationPauseIdAction = DataPageToolkit.createCheckAction(Messages.JavaApplicationPage_HALTS_ACTION, Messages.JavaApplicationPage_HALTS_ACTION_DESC, JavaApplicationPage.APPLICATION_PAUSE_ID, FlightRecorderUI.getDefault().getMCImageDescriptor("stop.png"), b -> this.buildChart());
            Stream<IAction> attributeActions = Stream.concat(JdkQueries.CPU_USAGE_SIMPLE_QUERY.getAttributes().stream(), Stream.of(JdkAttributes.HEAP_USED)).map(a -> DataPageToolkit.createAttributeCheckAction(a, b -> this.buildChart()));
            this.profilingCountAction = DataPageToolkit.createCheckAction(Messages.JavaApplicationPage_METHOD_PROFILING, Messages.JavaApplicationPage_METHOD_PROFILING_DESC, JavaApplicationPage.PROFILING_COUNT_COL, PROFILING_LEGEND_ICON, b -> this.buildChart());
            this.allocationAction = DataPageToolkit.createAggregatorCheckAction(JdkAggregators.ALLOCATION_TOTAL, JavaApplicationPage.ALLOCATION_COL, DataPageToolkit.ALLOCATION_COLOR, b -> this.buildChart());
            this.exceptionsAction = DataPageToolkit.createAggregatorCheckAction(JdkAggregators.THROWABLES_COUNT, JavaApplicationPage.EXCEPTIONS_COL, EXCEPTIONS_COLOR, b -> this.buildChart());
            this.threadActivityAction = DataPageToolkit.createCheckAction(Messages.JavaApplicationPage_THREAD_ACTIVITY_ACTION, Messages.JavaApplicationPage_THREAD_ACTIVITY_ACTION_DESC, JavaApplicationPage.ACTIVITY_LANES_ID, FlightRecorderUI.getDefault().getMCImageDescriptor("lanes.gif"), b -> this.buildChart());
            this.lanes = new ThreadGraphLanes(() -> JavaApplicationPage.this.getDataSource(), () -> this.buildChart());
            this.lanes.initializeChartConfiguration(Stream.of(state.getChildren(JavaApplicationPage.THREAD_LANE)));
            return Stream.concat(Stream.of(this.applicationPauseIdAction), Stream.concat(attributeActions, Stream.of(this.profilingCountAction, this.allocationAction, this.exceptionsAction, this.threadActivityAction))).collect(Collectors.toList());
        }

        private IItemCollection getDefaultSelection(IItemCollection items) {
            block16: {
                Object firstElement = ((IStructuredSelection)this.chartLegend.getSelection()).getFirstElement();
                if (firstElement == null) break block16;
                switch (((IAction)firstElement).getId()) {
                    case "profilingCount": {
                        return items.apply(JdkFilters.EXECUTION_SAMPLE);
                    }
                    case "allocation": {
                        return items.apply(JdkFilters.ALLOC_ALL);
                    }
                    case "exceptions": {
                        return items.apply(JdkFilters.THROWABLES);
                    }
                    case "threadActivityLanes": {
                        return items.apply(this.lanes.getEnabledLanesFilter());
                    }
                }
            }
            return ItemCollectionToolkit.EMPTY;
        }

        @Override
        protected void onFilterChange(IItemFilter filter) {
            super.onFilterChange(filter);
            JavaApplicationPage.this.tableFilter = filter;
        }

        @Override
        public void saveTo(IWritableState writableState) {
            super.saveTo(writableState);
            this.lanes.saveTo(writableState);
            this.tableFilterComponent.saveState(writableState.createChild(METHOD_PROFILING_TABLE_FILTER));
            this.saveToLocal();
        }

        private void saveToLocal() {
            JavaApplicationPage.this.tableState = this.table.getManager().getSelectionState();
            JavaApplicationPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }
    }
}

