/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.ColorToolkit;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FilterComponent;
import org.openjdk.jmc.flightrecorder.ui.common.ItemAggregateViewer;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.ItemRow;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.CompositeToolkit;
import org.openjdk.jmc.ui.misc.PersistableSashForm;

public class RecordingPage
extends AbstractDataPage {
    private static final String SASH = "sash";
    private static final String SASH2 = "eventSettingsSash";
    private static final String EVENT_SETTINGS = "eventSettings";
    private static final String CONCURRENT_RECORDINGS = "concurrentRecordings";
    private static final String EVENT_SETTINGS_FILTER = "eventSettingsFilter";
    private static final String CONCURRENT_RECORDINGS_FILTER = "concurrentRecordingsFilter";
    private IItemFilter recordingsTableFilter;
    private IItemFilter settingsTableFilter;
    private ColumnManager.SelectionState recordingsTableSelection;
    private ColumnManager.SelectionState settingsTableSelection;
    private IRange<IQuantity> timelineRange;

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new RecordingPageUi(parent, toolkit, pageContainer, state);
    }

    public RecordingPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
        this.timelineRange = editor.getRecordingRange();
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return ItemFilters.or((IItemFilter[])new IItemFilter[]{JdkFilters.RECORDING_SETTING, JdkFilters.RECORDINGS});
    }

    public static class RecordingPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.RecordingPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/recording.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"recording"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new RecordingPage(dpd, items, editor);
        }
    }

    private class RecordingPageUi
    implements IPageUI {
        private final ItemHistogram concurrentRecordingTable;
        private final ItemHistogram eventSettingsTable;
        private final SashForm sash;
        private IPageContainer pageContainer;
        private ChartCanvas timelineCanvas;
        private SashForm eventSettingsSash;
        private FilterComponent concurrentRecordingFilter;
        private FilterComponent eventSettingsFilter;
        private XYChart timelineChart;

        RecordingPageUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            this.pageContainer = pageContainer;
            Form form = DataPageToolkit.createForm(parent, toolkit, RecordingPage.this.getName(), RecordingPage.this.getIcon());
            this.sash = new SashForm(form.getBody(), 512);
            Section recInfoSection = CompositeToolkit.createSection((Composite)this.sash, (FormToolkit)toolkit, (String)Messages.RecordingPage_SECTION_RECORDING_INFORMATION);
            ItemAggregateViewer infoViewer = new ItemAggregateViewer((Composite)recInfoSection, toolkit, 2);
            infoViewer.addValueFunction(ic -> UnitLookup.EPOCH_NS.quantity(((IQuantity)pageContainer.getRecordingRange().getStart()).clampedLongValueIn((IUnit)UnitLookup.EPOCH_NS)), Messages.RecordingPage_RECORDING_EVENTS_START, Messages.RecordingPage_RECORDING_EVENT_START_DESC);
            infoViewer.addAggregate(JdkAggregators.ITEM_COUNT);
            infoViewer.addValueFunction(ic -> UnitLookup.EPOCH_NS.quantity(((IQuantity)pageContainer.getRecordingRange().getEnd()).clampedLongValueIn((IUnit)UnitLookup.EPOCH_NS)), Messages.RecordingPage_RECORDING_EVENTS_END, Messages.RecordingPage_RECORDING_EVENT_END_DESC);
            infoViewer.addAggregate(JdkAggregators.DUMP_REASON);
            infoViewer.addValueFunction(ic -> UnitLookup.NANOSECOND.quantity(((IQuantity)pageContainer.getRecordingRange().getExtent()).clampedLongValueIn((IUnit)UnitLookup.NANOSECOND)), Messages.RecordingPage_RECORDING_EVENT_DURATION, Messages.RecordingPage_RECORDING_EVENT_DURATION_DESC);
            recInfoSection.setClient(infoViewer.getControl());
            Section s1 = CompositeToolkit.createSection((Composite)this.sash, (FormToolkit)toolkit, (String)Messages.RecordingPage_SECTION_CONCURRENT_RECORDINGS);
            this.concurrentRecordingTable = DataPageToolkit.createDistinctItemsTable((Composite)s1, RecordingPage.this.getDataSource().getItems(), JdkQueries.RECORDINGS, new TableSettings(state.getChild(RecordingPage.CONCURRENT_RECORDINGS)));
            this.concurrentRecordingFilter = FilterComponent.createFilterComponent(this.concurrentRecordingTable, RecordingPage.this.recordingsTableFilter, RecordingPage.this.getDataSource().getItems().apply(JdkQueries.RECORDINGS.getFilter()), pageContainer.getSelectionStore()::getSelections, this::onRecordingsFilterChange);
            MCContextMenuManager concurrentRecordingMm = MCContextMenuManager.create((Control)this.concurrentRecordingTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.concurrentRecordingTable.getManager(), (MCContextMenuManager)concurrentRecordingMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.concurrentRecordingTable, Messages.RecordingPage_CONCURRENT_RECORDINGS_SELECTION, (IContributionManager)concurrentRecordingMm);
            concurrentRecordingMm.add(this.concurrentRecordingFilter.getShowFilterAction());
            concurrentRecordingMm.add(this.concurrentRecordingFilter.getShowSearchAction());
            ColumnViewer v1 = this.concurrentRecordingTable.getManager().getViewer();
            v1.addSelectionChangedListener(e -> pageContainer.showSelection(this.concurrentRecordingTable.getSelection().getItems()));
            this.concurrentRecordingFilter.loadState(state.getChild(RecordingPage.CONCURRENT_RECORDINGS_FILTER));
            s1.setClient((Control)this.concurrentRecordingFilter.getComponent());
            Section s2 = CompositeToolkit.createSection((Composite)this.sash, (FormToolkit)toolkit, (String)Messages.RecordingPage_SECTION_EVENT_SETTINGS);
            this.eventSettingsSash = new SashForm((Composite)s2, 512);
            this.timelineCanvas = new ChartCanvas((Composite)this.eventSettingsSash);
            toolkit.adapt((Composite)this.timelineCanvas);
            this.timelineChart = new XYChart(pageContainer.getRecordingRange(), RendererToolkit.empty(), 60, 10);
            this.timelineChart.setVisibleRange((IQuantity)RecordingPage.this.timelineRange.getStart(), (IQuantity)RecordingPage.this.timelineRange.getEnd());
            this.timelineChart.addVisibleRangeListener(r -> {
                IRange iRange = RecordingPage.this.timelineRange = r;
            });
            this.timelineCanvas.setLayoutData((Object)new GridData(4, 128, true, false));
            DataPageToolkit.createChartTimestampTooltip(this.timelineCanvas);
            this.eventSettingsTable = DataPageToolkit.createDistinctItemsTable((Composite)this.eventSettingsSash, RecordingPage.this.getDataSource().getItems(), JdkQueries.RECORDING_SETTINGS, new TableSettings(state.getChild(RecordingPage.EVENT_SETTINGS)));
            this.eventSettingsFilter = FilterComponent.createFilterComponent(this.eventSettingsTable, RecordingPage.this.settingsTableFilter, RecordingPage.this.getDataSource().getItems().apply(JdkQueries.RECORDING_SETTINGS.getFilter()), pageContainer.getSelectionStore()::getSelections, this::onSettingsFilterChange);
            MCContextMenuManager eventSettingsMm = MCContextMenuManager.create((Control)this.eventSettingsTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.eventSettingsTable.getManager(), (MCContextMenuManager)eventSettingsMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.eventSettingsTable, Messages.RecordingPage_EVENT_SETTINGS_SELECTION, (IContributionManager)eventSettingsMm);
            eventSettingsMm.add(this.eventSettingsFilter.getShowFilterAction());
            eventSettingsMm.add(this.eventSettingsFilter.getShowSearchAction());
            ColumnViewer v2 = this.eventSettingsTable.getManager().getViewer();
            v2.addSelectionChangedListener(e -> pageContainer.showSelection(this.eventSettingsTable.getSelection().getItems()));
            this.eventSettingsFilter.loadState(state.getChild(RecordingPage.EVENT_SETTINGS_FILTER));
            s2.setClient((Control)this.eventSettingsSash);
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(RecordingPage.SASH));
            PersistableSashForm.loadState((SashForm)this.eventSettingsSash, (IState)state.getChild(RecordingPage.SASH2));
            IItemCollection items = RecordingPage.this.getDataSource().getItems();
            infoViewer.setValues(items);
            this.updateRecordingTable(items);
            this.updateSettingsBarChart(items);
            this.updateSettingsTable(items);
            RecordingPage.this.addResultActions(form);
            this.onRecordingsFilterChange(RecordingPage.this.recordingsTableFilter);
            this.onSettingsFilterChange(RecordingPage.this.settingsTableFilter);
            this.concurrentRecordingTable.getManager().setSelectionState(RecordingPage.this.recordingsTableSelection);
            this.eventSettingsTable.getManager().setSelectionState(RecordingPage.this.settingsTableSelection);
        }

        private void updateRecordingTable(IItemCollection items) {
            this.concurrentRecordingTable.show(items.apply(JdkQueries.RECORDINGS.getFilter()));
        }

        private void updateSettingsBarChart(IItemCollection items) {
            IItemCollection settingsItems = items.apply(JdkQueries.RECORDING_SETTINGS.getFilter());
            ItemRow eventCount = DataPageToolkit.buildTimestampHistogram(Aggregators.count().getName(), Aggregators.count().getDescription(), settingsItems, Aggregators.count(), ColorToolkit.getDistinguishableColor((Object)"jdk.ActiveSetting"));
            this.timelineChart.setRendererRoot((IXDataRenderer)eventCount);
            DataPageToolkit.setChart(this.timelineCanvas, this.timelineChart, this.pageContainer::showSelection, this::onChartRangeSelection);
        }

        private void onChartRangeSelection(IRange<IQuantity> range) {
            range = range != null ? range : this.pageContainer.getRecordingRange();
            IItemCollection itemsInRange = RecordingPage.this.getDataSource().getItems(range);
            this.updateSettingsTable(itemsInRange);
        }

        private void updateSettingsTable(IItemCollection items) {
            this.eventSettingsTable.show(items.apply(JdkQueries.RECORDING_SETTINGS.getFilter()));
        }

        private void onRecordingsFilterChange(IItemFilter filter) {
            this.concurrentRecordingFilter.filterChangeHelper(filter, this.concurrentRecordingTable, RecordingPage.this.getDataSource().getItems().apply(JdkQueries.RECORDINGS.getFilter()));
            RecordingPage.this.recordingsTableFilter = filter;
        }

        private void onSettingsFilterChange(IItemFilter filter) {
            this.eventSettingsFilter.filterChangeHelper(filter, this.eventSettingsTable, RecordingPage.this.getDataSource().getItems().apply(JdkQueries.RECORDING_SETTINGS.getFilter()));
            RecordingPage.this.settingsTableFilter = filter;
        }

        public void saveTo(IWritableState memento) {
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)memento.createChild(RecordingPage.SASH));
            PersistableSashForm.saveState((SashForm)this.eventSettingsSash, (IWritableState)memento.createChild(RecordingPage.SASH2));
            this.concurrentRecordingTable.getManager().getSettings().saveState(memento.createChild(RecordingPage.CONCURRENT_RECORDINGS));
            this.eventSettingsTable.getManager().getSettings().saveState(memento.createChild(RecordingPage.EVENT_SETTINGS));
            this.concurrentRecordingFilter.saveState(memento.createChild(RecordingPage.CONCURRENT_RECORDINGS_FILTER));
            this.eventSettingsFilter.saveState(memento.createChild(RecordingPage.EVENT_SETTINGS_FILTER));
            this.saveToLocal();
        }

        private void saveToLocal() {
            RecordingPage.this.recordingsTableSelection = this.concurrentRecordingTable.getManager().getSelectionState();
            RecordingPage.this.settingsTableSelection = this.eventSettingsTable.getManager().getSelectionState();
        }
    }
}

