/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.selection;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.RangeMatchPolicy;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.ui.selection.IItemStreamFlavor;
import org.openjdk.jmc.flightrecorder.ui.selection.IPropertyFlavor;

public class FlavorToolkit {
    public static Optional<IRange<IQuantity>> getRange(IItemStreamFlavor flavor) {
        Optional<IRange<IQuantity>> range = FlavorToolkit.extractTimestampRange(flavor);
        if (!range.isPresent()) {
            range = FlavorToolkit.calculateTimestampRange(flavor);
        }
        return range;
    }

    public static IItemFilter getRangeAndThreadFilter(IItemStreamFlavor flavor, boolean showConcurrent, boolean containedIn, boolean sameThreads) {
        return FlavorToolkit.getRangeAndThreadFilter(FlavorToolkit.getRange(flavor), FlavorToolkit.getThreads(flavor, showConcurrent, sameThreads), showConcurrent, containedIn, sameThreads);
    }

    public static IItemFilter getRangeAndThreadFilter(Optional<IRange<IQuantity>> range, Set<IMCThread> threads, boolean showConcurrent, boolean containedIn, boolean sameThreads) {
        IItemFilter rangeFilter = FlavorToolkit.getRangeFilter(range, showConcurrent, containedIn);
        IItemFilter threadFilter = FlavorToolkit.getThreadFilter(threads, sameThreads);
        if (rangeFilter != null && threadFilter != null) {
            return ItemFilters.and((IItemFilter[])new IItemFilter[]{rangeFilter, threadFilter});
        }
        if (rangeFilter != null) {
            return rangeFilter;
        }
        if (threadFilter != null) {
            return threadFilter;
        }
        return null;
    }

    private static IItemFilter getRangeFilter(Optional<IRange<IQuantity>> range, boolean showConcurrent, boolean containedIn) {
        if (showConcurrent && range.isPresent()) {
            RangeMatchPolicy rangePolicy = containedIn ? RangeMatchPolicy.CONTAINED_IN_CLOSED : RangeMatchPolicy.CLOSED_INTERSECTS_WITH_CLOSED;
            return ItemFilters.matchRange((RangeMatchPolicy)rangePolicy, (ICanonicalAccessorFactory)JfrAttributes.LIFETIME, range.get());
        }
        return null;
    }

    private static IItemFilter getThreadFilter(Set<IMCThread> threads, boolean sameThreads) {
        if (sameThreads && threads != null && !threads.isEmpty()) {
            return ItemFilters.memberOf((ICanonicalAccessorFactory)JfrAttributes.EVENT_THREAD, threads);
        }
        return null;
    }

    private static Optional<IRange<IQuantity>> extractTimestampRange(IItemStreamFlavor fromFlavor) {
        if (fromFlavor instanceof IPropertyFlavor) {
            return ((IPropertyFlavor)fromFlavor).getProperties().filter(p -> p.getAttribute().getContentType().equals(UnitLookup.TIMERANGE) || p.getAttribute().getContentType().equals(UnitLookup.TIMESTAMP) && p.getValue() instanceof IRange).map(p -> (IRange)p.getValue()).findFirst();
        }
        return Optional.empty();
    }

    private static Optional<IRange<IQuantity>> calculateTimestampRange(IItemStreamFlavor fromFlavor) {
        if (fromFlavor != null) {
            IItemCollection items = (IItemCollection)fromFlavor.evaluate();
            IQuantity startTime = RulesToolkit.getEarliestStartTime((IItemCollection)items);
            IQuantity endTime = RulesToolkit.getLatestEndTime((IItemCollection)items);
            if (startTime != null) {
                if (endTime != null && startTime.compareTo((Object)endTime) < 0) {
                    return Optional.of(QuantityRange.createWithEnd((IQuantity)startTime, (IQuantity)endTime));
                }
                return Optional.of(QuantityRange.createPoint((IQuantity)startTime));
            }
        }
        return Optional.empty();
    }

    public static Set<IMCThread> getThreads(IItemStreamFlavor flavor, boolean showConcurrent, boolean sameThreads) {
        if (showConcurrent && sameThreads && !flavor.isEmpty().booleanValue()) {
            Set<IMCThread> threads = FlavorToolkit.extractThreads(flavor);
            if (threads.isEmpty()) {
                threads = FlavorToolkit.calculateThreads(flavor);
            }
            return threads;
        }
        return Collections.emptySet();
    }

    private static Set<IMCThread> extractThreads(IItemStreamFlavor fromFlavor) {
        if (fromFlavor instanceof IPropertyFlavor) {
            return ((IPropertyFlavor)fromFlavor).getProperties().filter(p -> p.getAttribute().getContentType().equals(UnitLookup.THREAD)).flatMap(p -> p.getValue() instanceof Collection ? Stream.of(((Collection)p.getValue()).toArray()) : Stream.of(p.getValue())).map(v -> (IMCThread)v).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static Set<IMCThread> calculateThreads(IItemStreamFlavor fromFlavor) {
        if (fromFlavor != null) {
            IItemCollection items = (IItemCollection)fromFlavor.evaluate();
            IAggregator distinctThreadsAggregator = Aggregators.distinct((IAttribute)JfrAttributes.EVENT_THREAD);
            return (Set)items.getAggregate(distinctThreadsAggregator);
        }
        return Collections.emptySet();
    }

    public static Set<String> getThreadNames(Set<IMCThread> threads, IItemStreamFlavor flavor) {
        Set<String> threadNames = Collections.emptySet();
        if (threads != null && !threads.isEmpty()) {
            threadNames = threads.stream().map(t -> t.getThreadName()).collect(Collectors.toSet());
        } else if (flavor instanceof IPropertyFlavor && ((IPropertyFlavor)flavor).getProperties().anyMatch(FlavorToolkit::threadMatcher)) {
            return ((IPropertyFlavor)flavor).getProperties().filter(FlavorToolkit::threadMatcher).flatMap(FlavorToolkit::threadMapper).collect(Collectors.toSet());
        }
        return threadNames;
    }

    private static Stream<String> threadMapper(IPropertyFlavor.IProperty p) {
        if (p.getAttribute().equals((Object)JdkAttributes.EVENT_THREAD_NAME)) {
            if (p.getValue() instanceof String) {
                return Stream.of((String)p.getValue());
            }
            if (p.getValue() instanceof Collection) {
                return ((Collection)p.getValue()).stream().map(o -> (String)o);
            }
        }
        return Stream.empty();
    }

    private static Boolean threadMatcher(IPropertyFlavor.IProperty p) {
        return p.getAttribute().equals((Object)JdkAttributes.EVENT_THREAD_NAME);
    }
}

