/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.selection;

import java.text.MessageFormat;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.RangeMatchPolicy;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.ui.JfrPropertySheet;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.FlavoredSelectionBase;
import org.openjdk.jmc.flightrecorder.ui.selection.IItemStreamFlavor;
import org.openjdk.jmc.flightrecorder.ui.selection.IPropertyFlavor;

public class RangedChartSelection
extends FlavoredSelectionBase {
    private final IItemCollection selectedRowsItems;
    private final IAttribute<IRange<IQuantity>> xAttribute;
    private final IRange<IQuantity> range;
    private final IItemFilter rangeFilter;

    public RangedChartSelection(String name, IItemCollection selectedItems, IRange<IQuantity> selectionRange, RangeMatchPolicy matchPolicy, IAttribute<IRange<IQuantity>> xRangeAttribute) {
        super(name);
        this.range = selectionRange;
        this.xAttribute = xRangeAttribute;
        if (selectionRange != null) {
            this.rangeFilter = ItemFilters.matchRange((RangeMatchPolicy)matchPolicy, xRangeAttribute, selectionRange);
            this.selectedRowsItems = selectedItems.apply(this.rangeFilter);
        } else {
            this.rangeFilter = null;
            this.selectedRowsItems = selectedItems;
        }
    }

    @Override
    public Stream<IItemStreamFlavor> getFlavors(IItemFilter dstFilter, IItemCollection items, List<IAttribute<?>> dstAttributes) {
        IItemCollection dstItems = ItemCollectionToolkit.filterIfNotNull((IItemCollection)items, (IItemFilter)dstFilter);
        boolean itemsApplicableOnPage = ItemCollectionToolkit.filterIfNotNull((IItemCollection)this.selectedRowsItems, (IItemFilter)dstFilter).hasItems();
        Stream.Builder<IItemStreamFlavor> builder = Stream.builder();
        Predicate<IAttribute<?>> includeAttributes = a -> true;
        IItemStreamFlavor selectedItemsFlavor = IItemStreamFlavor.build(MessageFormat.format(Messages.FLAVOR_SELECTED_EVENTS, ItemCollectionToolkit.getDescription((IItemCollection)this.selectedRowsItems)), this.selectedRowsItems);
        if (this.rangeFilter != null) {
            IPropertyFlavor selectedRangeFlavor = this.buildRange(MessageFormat.format(Messages.FLAVOR_SELECTED_RANGE, IPropertyFlavor.getIntervalDescription(this.xAttribute, this.range)), items);
            if (!itemsApplicableOnPage) {
                builder.accept(selectedRangeFlavor);
            }
            if (this.selectedRowsItems.hasItems()) {
                builder.accept(selectedItemsFlavor);
                selectedItemsFlavor = null;
            }
            if (itemsApplicableOnPage) {
                builder.accept(selectedRangeFlavor);
            }
            includeAttributes = a -> !a.equals(this.xAttribute) && (!this.xAttribute.equals((Object)JfrAttributes.LIFETIME) || !a.equals(JfrAttributes.START_TIME) && !a.equals(JfrAttributes.END_TIME));
        } else if (this.selectedRowsItems.hasItems() && itemsApplicableOnPage) {
            builder.accept(selectedItemsFlavor);
            selectedItemsFlavor = null;
        }
        JfrPropertySheet.calculatePersistableFilterFlavors(this.selectedRowsItems, dstItems, items, dstAttributes, includeAttributes).forEach(builder::accept);
        if (selectedItemsFlavor != null) {
            builder.accept(selectedItemsFlavor);
        }
        return builder.build();
    }

    private IPropertyFlavor buildRange(String name, IItemCollection dstItems) {
        return IPropertyFlavor.buildRange(name, this.xAttribute, this.range, dstItems);
    }
}

