/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.websocket;

import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.eclipse.jetty.websocket.servlet.WebSocketUpgradeFilter;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.flightrecorder.serializers.dot.DotSerializer;
import org.openjdk.jmc.flightrecorder.serializers.json.FlameGraphJsonSerializer;
import org.openjdk.jmc.flightrecorder.serializers.json.IItemCollectionJsonSerializer;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.graph.StacktraceGraphModel;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.StacktraceTreeModel;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;

public class WebsocketServer {
    private static int MAX_MESSAGE_SIZE = 0x40000000;
    private static int IDLE_TIMEOUT_MINUTES = 5;
    private final int port;
    private Server server;
    private List<WebsocketConnectionHandler> handlers = new CopyOnWriteArrayList<WebsocketConnectionHandler>();
    private List<WebsocketConnectionHandler> treeHandlers = new CopyOnWriteArrayList<WebsocketConnectionHandler>();
    private List<WebsocketConnectionHandler> graphHandlers = new CopyOnWriteArrayList<WebsocketConnectionHandler>();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private IItemCollection currentSelection = null;

    public WebsocketServer(int port) {
        this.port = port;
        this.executorService.execute(() -> this.startServer());
    }

    public int getPort() {
        return this.port;
    }

    private void startServer() {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setHost("127.0.0.1");
        connector.setPort(this.port);
        this.server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)context, (servletContext, container) -> {
            container.setMaxBinaryMessageSize((long)MAX_MESSAGE_SIZE);
            container.setIdleTimeout(Duration.ofMinutes(IDLE_TIMEOUT_MINUTES));
            container.addMapping("/events/*", (req, resp) -> {
                String eventsJson = WebsocketServer.toEventsJsonString(this.currentSelection);
                WebsocketConnectionHandler handler = new WebsocketConnectionHandler(eventsJson);
                this.handlers.add(handler);
                return handler;
            });
            container.addMapping("/tree/*", (req, resp) -> {
                String treeJson = WebsocketServer.toTreeModelJsonString(this.currentSelection);
                WebsocketConnectionHandler handler = new WebsocketConnectionHandler(treeJson);
                this.treeHandlers.add(handler);
                return handler;
            });
            container.addMapping("/graph/*", (req, resp) -> {
                String dot = WebsocketServer.toGraphModelDotString(this.currentSelection);
                WebsocketConnectionHandler handler = new WebsocketConnectionHandler(dot);
                this.graphHandlers.add(handler);
                return handler;
            });
        });
        try {
            WebSocketUpgradeFilter.ensureFilter((ServletContext)context.getServletContext());
            FlightRecorderUI.getDefault().getLogger().log(Level.INFO, "Starting websocket server listening on port " + this.port);
            this.server.start();
            this.server.join();
        }
        catch (Exception e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "Failed to start websocket server", e);
        }
    }

    public void notifyAll(IItemCollection events) {
        this.currentSelection = events;
        this.notifyAllEventHandlers(events);
        this.notifyAllGraphHandlers(events);
        this.notifyAllTreeHandlers(events);
    }

    private void notifyAllEventHandlers(IItemCollection events) {
        this.handlers = this.notifyAllHandlers(events, this.handlers, WebsocketServer::toEventsJsonString);
    }

    private void notifyAllGraphHandlers(IItemCollection events) {
        this.graphHandlers = this.notifyAllHandlers(events, this.graphHandlers, WebsocketServer::toGraphModelDotString);
    }

    private void notifyAllTreeHandlers(IItemCollection events) {
        this.treeHandlers = this.notifyAllHandlers(events, this.treeHandlers, WebsocketServer::toTreeModelJsonString);
    }

    private static String toEventsJsonString(IItemCollection items) {
        if (items == null) {
            return null;
        }
        return IItemCollectionJsonSerializer.toJsonString((IItemCollection)items);
    }

    private static String toGraphModelDotString(IItemCollection items) {
        if (items == null) {
            return null;
        }
        FrameSeparator frameSeparator = new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false);
        StacktraceGraphModel model = new StacktraceGraphModel(frameSeparator, items, null);
        return DotSerializer.toDot((StacktraceGraphModel)model, (int)10000, new HashMap());
    }

    private static String toTreeModelJsonString(IItemCollection items) {
        if (items == null) {
            return null;
        }
        StacktraceTreeModel model = new StacktraceTreeModel(items);
        return FlameGraphJsonSerializer.toJson((StacktraceTreeModel)model);
    }

    private List<WebsocketConnectionHandler> notifyAllHandlers(IItemCollection events, List<WebsocketConnectionHandler> handlers, Function<IItemCollection, String> jsonSerializer) {
        if ((handlers = handlers.stream().filter(h -> h.isConnected()).collect(Collectors.toList())).size() == 0 || events == null) {
            return handlers;
        }
        String json = jsonSerializer.apply(events);
        handlers.forEach(handler -> handler.sendMessage(json));
        return handlers;
    }

    public void shutdown() {
        try {
            FlightRecorderUI.getDefault().getLogger().log(Level.INFO, "Stopping websocket server listening on port " + this.port);
            this.server.stop();
        }
        catch (Exception e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "Failed to stop websocket server", e);
        }
    }

    private static class WebsocketConnectionHandler
    extends WebSocketAdapter {
        private String firstMessage;

        WebsocketConnectionHandler(String firstMessage) {
            this.firstMessage = firstMessage;
        }

        public void sendMessage(String message) {
            if (this.getSession() != null && this.isConnected()) {
                FlightRecorderUI.getDefault().getLogger().log(Level.INFO, "Sending message to " + this.getSession().getRemoteAddress().toString());
                try {
                    this.getSession().getRemote().sendString(message);
                }
                catch (IOException e) {
                    FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "Failed to send websocket message", e);
                }
            }
        }

        public void onWebSocketConnect(Session sess) {
            super.onWebSocketConnect(sess);
            FlightRecorderUI.getDefault().getLogger().log(Level.INFO, "Socket connected to " + sess.getRemoteAddress().toString());
            try {
                if (this.firstMessage != null) {
                    this.getSession().getRemote().sendString(this.firstMessage);
                    this.firstMessage = null;
                }
            }
            catch (IOException e) {
                FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "Failed to show outline view", e);
            }
        }

        public void onWebSocketText(String message) {
            super.onWebSocketText(message);
        }

        public void onWebSocketClose(int statusCode, String reason) {
            super.onWebSocketClose(statusCode, reason);
            FlightRecorderUI.getDefault().getLogger().log(Level.INFO, "Socket closed: [" + statusCode + "] " + reason);
        }

        public void onWebSocketError(Throwable cause) {
            super.onWebSocketError(cause);
            if (cause.getCause() instanceof TimeoutException) {
                FlightRecorderUI.getDefault().getLogger().log(Level.INFO, "Websocket timed out");
            } else {
                FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "Websocket error", cause);
            }
        }
    }
}

