/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import org.openjdk.jmc.rjmx.common.RJMXCorePlugin;
import org.openjdk.jmc.rjmx.common.internal.SyntheticAttributeEntry;
import org.openjdk.jmc.rjmx.common.internal.SyntheticAttributeMBeanEntry;
import org.openjdk.jmc.rjmx.common.subscription.internal.AttributeValueToolkit;

public final class SyntheticAttributeRepository {
    private final Map<ObjectName, SyntheticAttributeMBeanEntry> mbeans = new HashMap<ObjectName, SyntheticAttributeMBeanEntry>();
    private final MBeanServer server = MBeanServerFactory.newMBeanServer();
    private final MBeanServerConnection compoundServer;

    public SyntheticAttributeRepository(MBeanServerConnection compoundServer) {
        this.compoundServer = compoundServer;
    }

    public void initializeFromExtensions(List<SyntheticAttributeEntry> attributeCandidates) {
        boolean hasResolved = true;
        while (!attributeCandidates.isEmpty() && hasResolved) {
            hasResolved = false;
            Iterator<SyntheticAttributeEntry> iterator = attributeCandidates.iterator();
            while (iterator.hasNext()) {
                SyntheticAttributeEntry candidate = iterator.next();
                if (!candidate.getAttribute().hasResolvedDependencies(this.compoundServer)) continue;
                hasResolved = true;
                iterator.remove();
                candidate.getAttribute().init(this.compoundServer);
                this.registerEntry(candidate);
            }
        }
    }

    private void registerEntry(SyntheticAttributeEntry attributeEntry) {
        ObjectName objectName = attributeEntry.getAttributeDescriptor().getObjectName();
        SyntheticAttributeMBeanEntry entry = this.mbeans.get(objectName);
        if (entry == null) {
            entry = new SyntheticAttributeMBeanEntry(this.compoundServer);
            try {
                this.server.registerMBean(entry, objectName);
                this.mbeans.put(objectName, entry);
            }
            catch (Exception e) {
                RJMXCorePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not register MBean for synthetic attribute!", e);
            }
        }
        entry.addSyntheticAttribute(attributeEntry);
    }

    public String[] getDomains() {
        return this.server.getDomains();
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.server.getObjectInstance(name);
    }

    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        return this.server.queryMBeans(name, query);
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        return this.server.queryNames(name, query);
    }

    public boolean isRegistered(ObjectName name) {
        return this.server.isRegistered(name);
    }

    public Integer getMBeanCount() {
        return this.server.getMBeanCount();
    }

    public boolean hasAttribute(ObjectName name, String dataPath) {
        SyntheticAttributeMBeanEntry entry = this.mbeans.get(name);
        if (entry == null) {
            return false;
        }
        return entry.hasDataPath(dataPath);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws IntrospectionException, InstanceNotFoundException, ReflectionException {
        return this.server.getMBeanInfo(name);
    }

    public Object getAttribute(ObjectName name, String attribute) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return AttributeValueToolkit.getAttribute(this.server, name, attribute);
    }

    public AttributeList getExistingAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        ArrayList<String> syntheticAttributes = new ArrayList<String>();
        for (String attribute : attributes) {
            if (!this.hasAttribute(name, attribute)) continue;
            syntheticAttributes.add(attribute);
        }
        if (syntheticAttributes.size() > 0) {
            return AttributeValueToolkit.getAttributes(this.server, name, syntheticAttributes);
        }
        return new AttributeList();
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, InvalidAttributeValueException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        this.server.setAttribute(name, attribute);
    }

    public AttributeList setExistingAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        AttributeList existingAttributes = new AttributeList();
        for (Object obj : attributes) {
            Attribute attribute = (Attribute)obj;
            if (!this.hasAttribute(name, attribute.getName())) continue;
            existingAttributes.add(attribute);
        }
        if (existingAttributes.size() > 0) {
            return this.server.setAttributes(name, existingAttributes);
        }
        return new AttributeList();
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.server.isInstanceOf(name, className);
    }

    public void dispose() {
        for (SyntheticAttributeMBeanEntry mbeanEntry : this.mbeans.values()) {
            for (SyntheticAttributeEntry entry : mbeanEntry.getSyntheticAttributes()) {
                try {
                    entry.getAttribute().stop();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

