/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import javax.management.remote.JMXServiceURL;
import javax.naming.NameNotFoundException;
import javax.naming.NoInitialContextException;
import org.openjdk.jmc.rjmx.common.ConnectionException;
import org.openjdk.jmc.rjmx.common.ConnectionToolkit;
import org.openjdk.jmc.rjmx.common.messages.internal.Messages;

public class WrappedConnectionException
extends ConnectionException {
    private final JMXServiceURL url;
    private final String serverName;

    public WrappedConnectionException(String serverName, JMXServiceURL url, Exception cause) {
        super(cause.getMessage());
        this.initCause(cause);
        this.url = url;
        this.serverName = serverName;
    }

    @Override
    public String getLocalizedMessage() {
        String protocol;
        Throwable cause;
        Throwable rootCause = cause = this.getCause();
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        String hostName = this.url != null ? ConnectionToolkit.getHostName(this.url) : Messages.getString("ConnectionException_UNRESOLVED");
        String string = protocol = this.url != null ? this.url.getProtocol() : Messages.getString("ConnectionException_UNRESOLVED");
        if (rootCause instanceof UnknownHostException) {
            return String.format(Messages.getString("ConnectionException_COULD_NOT_DETERMINE_IP_MSG"), hostName);
        }
        if (rootCause instanceof NameNotFoundException) {
            return String.format(Messages.getString("ConnectionException_NAME_NOT_FOUND_MSG"), this.serverName, this.url);
        }
        if (rootCause instanceof MalformedURLException) {
            return String.format(Messages.getString("ConnectionException_MALFORMED_URL_MSG"), this.serverName, this.url);
        }
        if (rootCause instanceof NoInitialContextException) {
            return String.format(Messages.getString("ConnectionException_UNABLE_TO_CREATE_INITIAL_CONTEXT"), this.serverName, this.url);
        }
        if (protocol.equals("msarmi")) {
            return String.format(Messages.getString("ConnectionException_MSARMI_CHECK_PASSWORD"), this.serverName, this.url);
        }
        if (rootCause instanceof SecurityException || rootCause instanceof GeneralSecurityException) {
            return String.format(Messages.getString("ConnectionException_UNABLE_TO_RESOLVE_CREDENTIALS"), this.serverName, rootCause.getLocalizedMessage());
        }
        if ("com.sun.tools.attach.AttachNotSupportedException".equals(rootCause.getClass().getName())) {
            return String.format(Messages.getString("ConnectionException_ATTACH_NOT_SUPPORTED"), this.serverName, rootCause.getLocalizedMessage());
        }
        return String.format(Messages.getString("ConnectionException_COULD_NOT_CONNECT_MSG"), this.serverName, this.url);
    }

    @Override
    public String toString() {
        return ConnectionException.class.getName() + " caused by " + this.getCause().toString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        throw new IOException("You should not serialize instances of " + this.getClass().getName());
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        throw new IOException("You should not serialize instances of " + this.getClass().getName());
    }
}

