/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.services.jfr.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.openjdk.jmc.common.unit.IConstrainedMap;
import org.openjdk.jmc.common.unit.IMutableConstrainedMap;
import org.openjdk.jmc.common.unit.IOptionDescriptor;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.flightrecorder.configuration.events.EventOptionID;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventTypeID;
import org.openjdk.jmc.flightrecorder.configuration.internal.KnownEventOptions;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.EventTypeMetadataV1;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.OpenTypeConverter;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.RecordingOptionsToolkitV1;

public final class EventOptionsToolkitV1 {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.rjmx.common.services.jfr");
    private static final String KEY_ID = "id";
    private static final String KEY_STACKTRACE_SERVER = "stacktrace";
    private static final String KEY_PERIOD_SERVER = "requestPeriod";
    private static final Map<String, OpenTypeConverter<?, ?>> CONVERTERS_BY_EVENT_OPTION_KEY;
    private static final Map<String, String> CAPABILITY_KEYS_BY_OPTION_KEY;
    private static final String[] SERVER_NAMES;
    private static final OpenType<?>[] OPEN_TYPES;
    public static final CompositeType OPTIONS_COMPOSITE_TYPE;

    private static CompositeType generateOptionsType() {
        try {
            return new CompositeType("EventOptions", "Event Options", SERVER_NAMES, SERVER_NAMES, OPEN_TYPES);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private EventOptionsToolkitV1() {
        throw new AssertionError((Object)"Not to be instantiated!");
    }

    public static Map<String, IOptionDescriptor<?>> getConfigurableOptions(CompositeData data) {
        HashMap optionMap = new HashMap();
        for (Map.Entry entry : KnownEventOptions.EVENT_OPTIONS_BY_KEY_V1.entrySet()) {
            String capKey = CAPABILITY_KEYS_BY_OPTION_KEY.get(entry.getKey());
            if (capKey != null && !Boolean.TRUE.equals(data.get(capKey))) continue;
            optionMap.put((String)entry.getKey(), (IOptionDescriptor)entry.getValue());
        }
        return optionMap;
    }

    public static List<CompositeData> encodeAllEventSettings(Collection<EventTypeMetadataV1> availableEventTypes, IConstrainedMap<EventOptionID> settings) throws OpenDataException {
        ArrayList<CompositeData> eventSettings = new ArrayList<CompositeData>();
        for (EventTypeMetadataV1 eventType : availableEventTypes) {
            Object[] values = new Object[]{eventType.getId(), -1L, Boolean.FALSE, -1L, Boolean.FALSE};
            int i = 1;
            for (Map.Entry<String, OpenTypeConverter<?, ?>> entry : CONVERTERS_BY_EVENT_OPTION_KEY.entrySet()) {
                EventOptionID optionID;
                Object value;
                if (eventType.getOptionInfo(entry.getKey()) != null && (value = settings.get((Object)(optionID = new EventOptionID((IEventTypeID)eventType.getEventTypeID(), entry.getKey())))) != null) {
                    try {
                        values[i] = RecordingOptionsToolkitV1.toOpenTypeWithCast(entry.getValue(), value);
                    }
                    catch (QuantityConversionException e) {
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                ++i;
            }
            eventSettings.add(new CompositeDataSupport(OPTIONS_COMPOSITE_TYPE, SERVER_NAMES, values));
        }
        return eventSettings;
    }

    public static void addOptionsToV1(IMutableConstrainedMap<EventOptionID> options, EventTypeMetadataV1 eventType, CompositeData data) {
        Iterator<String> iterator = data.getCompositeType().keySet().iterator();
        while (iterator.hasNext()) {
            String serverKey;
            String localKey = serverKey = iterator.next();
            if (serverKey.equals(KEY_PERIOD_SERVER)) {
                localKey = "period";
            } else if (localKey.equals(KEY_STACKTRACE_SERVER)) {
                localKey = "stackTrace";
            }
            IOptionDescriptor<?> optionInfo = eventType.getOptionInfo(localKey);
            OpenTypeConverter<?, ?> converter = CONVERTERS_BY_EVENT_OPTION_KEY.get(localKey);
            if (optionInfo == null || converter == null) continue;
            assert (optionInfo.getConstraint() == converter.constraint);
            EventOptionID optionID = new EventOptionID((IEventTypeID)eventType.getEventTypeID(), localKey);
            try {
                EventOptionsToolkitV1.putWithCast(options, optionID, converter, data.get(serverKey));
            }
            catch (QuantityConversionException e) {
                LOGGER.log(Level.WARNING, "Problem with value for option " + optionID, e);
            }
        }
    }

    static <K, P, T> void putWithCast(IMutableConstrainedMap<K> map, K key, OpenTypeConverter<P, T> converter, Object openValue) throws QuantityConversionException {
        T value = converter.fromOpenType(converter.getType().cast(openValue));
        map.put(key, converter.constraint, value);
    }

    static {
        SERVER_NAMES = new String[]{KEY_ID, "threshold", KEY_STACKTRACE_SERVER, KEY_PERIOD_SERVER, "enabled"};
        OPEN_TYPES = new OpenType[]{SimpleType.INTEGER, SimpleType.LONG, SimpleType.BOOLEAN, SimpleType.LONG, SimpleType.BOOLEAN};
        LinkedHashMap converters = new LinkedHashMap();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        converters.put("threshold", OpenTypeConverter.NANOSECONDS);
        capabilities.put("threshold", "isTimed");
        converters.put("stackTrace", OpenTypeConverter.BOOLEAN);
        capabilities.put("stackTrace", "isStackTraceAvailable");
        converters.put("period", OpenTypeConverter.MILLIS_PERIODICITY);
        capabilities.put("period", "isRequestable");
        converters.put("enabled", OpenTypeConverter.BOOLEAN);
        CONVERTERS_BY_EVENT_OPTION_KEY = converters;
        CAPABILITY_KEYS_BY_OPTION_KEY = capabilities;
        OPTIONS_COMPOSITE_TYPE = EventOptionsToolkitV1.generateOptionsType();
    }
}

