/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.services.jfr.internal;

import java.util.Date;
import java.util.Map;
import javax.management.ObjectName;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.configuration.IRecordingDescriptor;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.OpenTypeConverter;

public final class RecordingDescriptorV1
implements IRecordingDescriptor {
    private final String serverId;
    private final ObjectName objectName;
    private final Long id;
    private final String name;
    private final Map<String, ?> options;
    private final IRecordingDescriptor.RecordingState state;
    private final IQuantity dataStartTime;
    private final IQuantity dataEndTime;

    RecordingDescriptorV1(String serverId, Long id, String name, boolean isStarted, boolean isStopped, boolean isRunning, Map<String, ?> options, IQuantity dataStartTime, IQuantity dataEndTime, ObjectName objectName) {
        this.serverId = serverId;
        this.id = id;
        this.name = name;
        this.state = this.decideState(isStarted, isStopped, isRunning);
        this.options = options;
        this.objectName = objectName;
        this.dataStartTime = dataStartTime;
        this.dataEndTime = dataEndTime;
    }

    private IRecordingDescriptor.RecordingState decideState(boolean isStarted, boolean isStopped, boolean isRunning) {
        if (!isStarted) {
            return IRecordingDescriptor.RecordingState.CREATED;
        }
        if (isRunning) {
            return IRecordingDescriptor.RecordingState.RUNNING;
        }
        if (isStopped) {
            return IRecordingDescriptor.RecordingState.STOPPED;
        }
        return IRecordingDescriptor.RecordingState.STOPPING;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public IRecordingDescriptor.RecordingState getState() {
        return this.state;
    }

    public Map<String, ?> getOptions() {
        return this.options;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public boolean equals(Object o) {
        if (o instanceof RecordingDescriptorV1) {
            RecordingDescriptorV1 that = (RecordingDescriptorV1)o;
            return that.id.equals(this.id) && that.serverId.equals(this.serverId);
        }
        return false;
    }

    public int hashCode() {
        return this.id.intValue() ^ this.serverId.hashCode();
    }

    public String toString() {
        return "RecordingDescriptor@" + this.serverId + "[" + this.getName() + "(" + this.getId() + "), " + this.getState() + ", " + this.getOptions() + "]";
    }

    public IQuantity getDataStartTime() {
        return this.dataStartTime;
    }

    public IQuantity getDataEndTime() {
        return this.dataEndTime;
    }

    public IQuantity getStartTime() {
        Object startTime = this.getOptions().get("startTime");
        if (startTime instanceof Date) {
            return UnitLookup.fromDate((Date)((Date)startTime));
        }
        return null;
    }

    public IQuantity getDuration() {
        return this.getLongQuantity((IUnit)UnitLookup.MILLISECOND, "duration");
    }

    public boolean isContinuous() {
        IQuantity duration = this.getDuration();
        return duration == null || duration.doubleValue() == 0.0;
    }

    public boolean getToDisk() {
        Object object = this.getOptions().get("toDisk");
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    public IQuantity getMaxAge() {
        return this.getLongQuantity((IUnit)UnitLookup.MILLISECOND, "maxAge");
    }

    public IQuantity getMaxSize() {
        return this.getLongQuantity((IUnit)UnitLookup.BYTE, "maxSize");
    }

    private IQuantity getLongQuantity(IUnit unit, String optionKey) {
        Object object = this.getOptions().get(optionKey);
        if (object instanceof Long) {
            return OpenTypeConverter.inGuessedUnit(unit.quantity((Number)((Long)object)));
        }
        return null;
    }
}

