/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.subscription.internal;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.openjdk.jmc.rjmx.common.RJMXCorePlugin;
import org.openjdk.jmc.rjmx.common.subscription.IMRITransformation;
import org.openjdk.jmc.rjmx.common.subscription.IMRITransformationFactory;
import org.openjdk.jmc.rjmx.common.subscription.MRI;

public class SingleMRITransformationFactory
implements IMRITransformationFactory {
    private static final String TRANSFORMATION_CLASS_NAME_PROPERTY = "transformationClass";
    private Properties m_properties;
    private Properties m_transformationProperties;

    @Override
    public void setFactoryProperties(Properties properties, Properties transformationProperties) {
        this.m_properties = properties;
        this.m_transformationProperties = transformationProperties;
    }

    @Override
    public IMRITransformation createTransformation(Properties properties) {
        String className = this.m_properties.getProperty(TRANSFORMATION_CLASS_NAME_PROPERTY);
        if (className == null) {
            return null;
        }
        try {
            Class<?> clz = Class.forName(className);
            IMRITransformation transformation = (IMRITransformation)clz.newInstance();
            properties.putAll((Map<?, ?>)this.m_transformationProperties);
            transformation.setProperties(properties);
            return transformation;
        }
        catch (ClassNotFoundException e) {
            this.logException(e);
        }
        catch (InstantiationException e) {
            this.logException(e);
        }
        catch (IllegalAccessException e) {
            this.logException(e);
        }
        return null;
    }

    private void logException(Exception e) {
        RJMXCorePlugin.getDefault().getLogger().log(Level.WARNING, "Unable to create transformation!", e);
    }

    @Override
    public String getVisualizationLabel() {
        return this.m_properties.getProperty("visualizeLabel");
    }

    @Override
    public MRI createTransformationMRI(MRI mri) {
        String transformationName = this.m_properties.getProperty("transformationName");
        return new MRI(MRI.Type.TRANSFORMATION, "transformation:type=" + transformationName, transformationName + "?attribute=" + mri);
    }
}

