/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.alert;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.openjdk.jmc.alert.AlertObject;
import org.openjdk.jmc.alert.AlertPlugin;
import org.openjdk.jmc.alert.Messages;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.TypedLabelProvider;

public class AlertDialog
extends TitleAreaDialog {
    private Button m_clearButton;
    private Text m_text;
    private TableViewer m_viewer;

    protected void createButtonsForButtonBar(Composite parent) {
        this.createPopupButton(parent);
        this.createClearButton(parent);
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    private void createPopupButton(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        final Button button = new Button(parent, 32);
        button.setText(Messages.AlertDialog_POP_UP_ON_ALERTS_TEXT);
        button.setSelection(AlertPlugin.getDefault().getPopup());
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (button != null && !button.isDisposed()) {
                    AlertPlugin.getDefault().setPopup(button.getSelection());
                }
            }
        });
    }

    protected void createClearButton(Composite parent) {
        this.m_clearButton = this.createButton(parent, 1024, Messages.AlertDialog_CLEAR_ALERTS_TEXT0, true);
        this.m_clearButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AlertPlugin.getDefault().clearNotificationEventLog();
                AlertDialog.this.m_text.setText("");
                AlertDialog.this.m_viewer.setInput(null);
            }
        });
    }

    public AlertDialog(Shell parentShell) {
        super(parentShell);
        this.setTitleImage(AlertPlugin.getDefault().getImage("AlertBanner"));
        this.setShellStyle(0x860 | AlertDialog.getDefaultOrientation() | 0x10 | 0x400);
        this.setBlockOnOpen(false);
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(Messages.AlertDialog_DIALOG_TITLE);
        this.getShell().setImage(UIPlugin.getDefault().getImage("alert_obj.png"));
        Control contents = super.createContents(parent);
        this.setTitle(Messages.AlertDialog_DIALOG_TITLE);
        this.setMessage(Messages.AlertDialog_DIALOG_MESSAGE);
        DisplayToolkit.placeDialogInCenter((Shell)this.getParentShell(), (Shell)this.getShell());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Control dialogArea = super.createDialogArea(parent);
        SashForm sash = new SashForm((Composite)dialogArea, 512);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        TableViewer viewer = this.createViewer((Composite)sash);
        viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_text = this.createMessage((Composite)sash);
        this.m_text.setLayoutData((Object)new GridData(4, 4, true, false));
        sash.setWeights(new int[]{75, 25});
        sash.setLayout((Layout)new GridLayout());
        return dialogArea;
    }

    private Text createMessage(Composite parent) {
        Text text = new Text(parent, 2634);
        return text;
    }

    public void select(AlertObject alertObject) {
        this.m_text.setText(alertObject.getMessage());
    }

    public TableViewer createViewer(Composite parent) {
        Table table = new Table(parent, 8456194);
        this.m_viewer = new TableViewer(table);
        ArrayList<IColumn> columns = new ArrayList<IColumn>();
        columns.add(new ColumnBuilder(Messages.AlertDialog_COLUMN_HEADER_DATE, "date", (ColumnLabelProvider)new DateLabelProvider()).comparator((Comparator)new DateComparator()).build());
        columns.add(new ColumnBuilder(Messages.AlertDialog_COLUMN_HEADER_RULE, "rule", (ColumnLabelProvider)new RuleLabelProvider()).build());
        columns.add(new ColumnBuilder(Messages.AlertDialog_COLUMN_HEADER_SOURCE, "source", (ColumnLabelProvider)new SourceLabelProvider()).build());
        ColumnManager.build((TableViewer)this.m_viewer, columns, null);
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                if (ssel.size() >= 1) {
                    AlertDialog.this.select((AlertObject)ssel.getFirstElement());
                }
            }
        });
        this.m_viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.m_viewer.setInput((Object)AlertPlugin.getDefault().getAlerts());
        return this.m_viewer;
    }

    public void refreshAlertDialog() {
        if (this.m_viewer != null && !this.m_viewer.getTable().isDisposed()) {
            this.m_viewer.setInput((Object)AlertPlugin.getDefault().getAlerts());
        }
    }

    private static class AlertLabelProvider
    extends TypedLabelProvider<AlertObject> {
        public AlertLabelProvider() {
            super(AlertObject.class);
        }

        protected Color getForegroundTyped(AlertObject ao) {
            return ao.getException() == null ? null : Display.getCurrent().getSystemColor(3);
        }

        protected Color getBackgroundTyped(AlertObject ao) {
            return ao.getException() == null ? null : Display.getCurrent().getSystemColor(7);
        }
    }

    private static class DateComparator
    implements Comparator<Object> {
        private DateComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return ((AlertObject)o1).getCreationTime().compareTo(((AlertObject)o2).getCreationTime());
        }
    }

    private static class DateLabelProvider
    extends AlertLabelProvider {
        DateFormat df = DateFormat.getDateTimeInstance();

        private DateLabelProvider() {
        }

        protected String getTextTyped(AlertObject element) {
            return this.df.format(element.getCreationTime());
        }

        protected Image getImageTyped(AlertObject ao) {
            boolean ex = ao.getException() != null;
            return UIPlugin.getDefault().getImage(ex ? "alert_obj.png" : "jexception_obj.png");
        }
    }

    private static class RuleLabelProvider
    extends AlertLabelProvider {
        private RuleLabelProvider() {
        }

        protected String getTextTyped(AlertObject ao) {
            return String.valueOf(ao.getRule().getRulePath()) + "\\" + ao.getRule().getName();
        }
    }

    private static class SourceLabelProvider
    extends AlertLabelProvider {
        private SourceLabelProvider() {
        }

        protected String getTextTyped(AlertObject ao) {
            return ao.getSourceName();
        }
    }
}

