/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.alert;

import java.io.StringWriter;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.alert.Messages;
import org.openjdk.jmc.rjmx.triggers.TriggerEvent;

public final class NotificationUIToolkit {
    private NotificationUIToolkit() {
    }

    public static String prettyPrint(TriggerEvent e) {
        if (e.wasTriggered()) {
            return NotificationUIToolkit.prettyPrint(e, Messages.NotificationUIToolkit_EVENT_TOOLKIT_NOTIFICATION_TRIGGERED);
        }
        if (e.wasRecovered()) {
            return NotificationUIToolkit.prettyPrint(e, Messages.NotificationUIToolkit_EVENT_TOOLKIT_NOTIFICATION_RECOVERED);
        }
        return NotificationUIToolkit.prettyPrint(e, null);
    }

    public static String prettyPrint(TriggerEvent e, String title) {
        StringWriter writer = new StringWriter();
        NotificationUIToolkit.prettyPrint(writer, e, title);
        return writer.toString();
    }

    public static void prettyPrint(StringWriter writer, TriggerEvent e, String title) {
        if (title != null) {
            NotificationUIToolkit.println(writer, title);
            writer.append("\n");
        }
        NotificationUIToolkit.println(writer, NLS.bind((String)Messages.NotificationUIToolkit_EVENT_TOOLKIT_NOTIFICATION_CREATION_TIME, (Object)e.getCreationTime()));
        NotificationUIToolkit.println(writer, NLS.bind((String)Messages.NotificationUIToolkit_EVENT_TOOLKIT_NOTIFICATION_SOURCE, (Object)e.getConnectorSourceDescription()));
        NotificationUIToolkit.println(writer, NLS.bind((String)Messages.NotificationUIToolkit_EVENT_TOOLKIT_NOTIFICATION_RULE, (Object)e.getRule().getName()));
        NotificationUIToolkit.println(writer, NLS.bind((String)Messages.NotificationUIToolkit_EVENT_TOOLKIT_TYPE_DESCRIPTION, (Object)e.getRule().getTrigger().getAttributeDescriptor()));
        if (e.getSustainTime() > 0) {
            NotificationUIToolkit.println(writer, NLS.bind((String)Messages.NotificationUIToolkit_EVENT_TOOLKIT_TRIGGER_CONDITION_OPTIONAL_SUSTAIN, (Object)e.getRule().getTrigger().getValueEvaluator(), (Object)e.getRule().getTrigger().getSustainTime()));
        } else {
            NotificationUIToolkit.println(writer, NLS.bind((String)Messages.NotificationUIToolkit_EVENT_TOOLKIT_RULE_TRIGGER_CONDITION, (Object)e.getRule().getTrigger().getValueEvaluator()));
        }
        NotificationUIToolkit.println(writer, NLS.bind((String)Messages.NotificationUIToolkit_EVENT_TOOLKIT_ACTUAL_TRIGGER_VALUE, (Object)e.getTriggerValue().toString()));
        writer.append("\n");
    }

    private static void println(StringWriter writer, String string) {
        writer.append(string);
        writer.append("\n");
    }
}

