/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.FutureTask;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class SlidingWindowToolkit {
    private static final Comparator<IQuantity> QUANTITY_COMPARATOR = new Comparator<IQuantity>(){

        @Override
        public int compare(IQuantity o1, IQuantity o2) {
            return o1.compareTo((Object)o2);
        }
    };

    public static void slidingWindowOrdered(IOrderedWindowVisitor callback, Iterator<IItem> items, IMemberAccessor<IQuantity, IItem> posAccessor, IQuantity windowSize, IQuantity slideSize) {
        IQuantity windowStart = null;
        ArrayList<IItem> windowItems = new ArrayList<IItem>();
        Iterator<IItem> iterator = items;
        while (iterator.hasNext() && callback.shouldContinue()) {
            IItem wi;
            IItem item = iterator.next();
            windowStart = windowItems.isEmpty() ? (IQuantity)posAccessor.getMember((Object)item) : (IQuantity)posAccessor.getMember((Object)((IItem)windowItems.get(0)));
            windowItems.add(item);
            IQuantity windowEnd = (IQuantity)posAccessor.getMember((Object)item);
            while (iterator.hasNext() && windowEnd.subtract(windowSize).compareTo((Object)windowStart) < 0 && callback.shouldContinue()) {
                IItem next = iterator.next();
                windowEnd = (IQuantity)posAccessor.getMember((Object)next);
                windowItems.add(next);
            }
            callback.visitWindow(windowItems.iterator());
            if (slideSize == null) {
                if (windowItems.size() <= 1) continue;
                windowItems.remove(0);
                continue;
            }
            IQuantity newStart = windowStart.add(slideSize);
            Iterator it = windowItems.iterator();
            while (it.hasNext() && callback.shouldContinue() && ((IQuantity)posAccessor.getMember((Object)(wi = (IItem)it.next()))).compareTo((Object)newStart) < 0) {
                it.remove();
            }
        }
    }

    public static void slidingWindowUnordered(IUnorderedWindowVisitor callback, IItemCollection items, IQuantity windowSize, IQuantity slideSize) {
        SlidingWindowToolkit.slidingWindowUnordered(callback, items, windowSize, slideSize, false);
    }

    public static void slidingWindowUnordered(IUnorderedWindowVisitor callback, IItemCollection items, IQuantity windowSize, IQuantity slideSize, boolean includeIntersecting) {
        IQuantity first = includeIntersecting ? RulesToolkit.getEarliestStartTime(items) : RulesToolkit.getEarliestEndTime(items);
        IQuantity last = RulesToolkit.getLatestEndTime(items);
        if (first == null) {
            return;
        }
        IQuantity windowStart = first;
        IQuantity windowEnd = windowStart.add(windowSize);
        do {
            IItemFilter window = includeIntersecting ? ItemFilters.rangeIntersects((ICanonicalAccessorFactory)JfrAttributes.LIFETIME, (IRange)QuantityRange.createWithEnd((IQuantity)windowStart, (IQuantity)windowEnd)) : ItemFilters.interval((ICanonicalAccessorFactory)JfrAttributes.END_TIME, (Comparable)windowStart, (boolean)true, (Comparable)windowEnd, (boolean)true);
            IItemCollection windowItems = items.apply(window);
            callback.visitWindow(windowItems, windowStart, windowEnd);
            windowStart = windowStart.add(slideSize);
            windowEnd = windowEnd.add(slideSize);
        } while (windowStart.compareTo((Object)last) < 0 && callback.shouldContinue());
    }

    public static Pair<IQuantity, IRange<IQuantity>> slidingWindowUnorderedMinMaxValue(IItemCollection items, IQuantity windowSize, FutureTask<IResult> cancellationSupplier, IUnorderedWindowValueFunction<IQuantity> valueFunction, boolean max, boolean includeIntersecting) {
        IQuantity slideSize = windowSize.getUnit().quantity(windowSize.ratioTo(windowSize.getUnit().quantity(2L)));
        return SlidingWindowToolkit.slidingWindowUnorderedMinMaxValue(items, windowSize, slideSize, cancellationSupplier, valueFunction, max, includeIntersecting);
    }

    public static Pair<IQuantity, IRange<IQuantity>> slidingWindowUnorderedMinMaxValue(IItemCollection items, IQuantity windowSize, IQuantity slideSize, FutureTask<IResult> cancellationSupplier, IUnorderedWindowValueFunction<IQuantity> valueFunction, boolean max, boolean includeIntersecting) {
        return SlidingWindowToolkit.slidingWindowUnorderedMinMaxValue(items, windowSize, slideSize, cancellationSupplier, valueFunction, QUANTITY_COMPARATOR, max, includeIntersecting);
    }

    public static <V> Pair<V, IRange<IQuantity>> slidingWindowUnorderedMinMaxValue(IItemCollection items, IQuantity windowSize, FutureTask<IResult> cancellationSupplier, IUnorderedWindowValueFunction<V> valueFunction, Comparator<V> valueComparator, boolean max, boolean includeIntersecting) {
        IQuantity slideSize = windowSize.getUnit().quantity(windowSize.ratioTo(windowSize.getUnit().quantity(2L)));
        return SlidingWindowToolkit.slidingWindowUnorderedMinMaxValue(items, windowSize, slideSize, cancellationSupplier, valueFunction, valueComparator, max, includeIntersecting);
    }

    public static <V> Pair<V, IRange<IQuantity>> slidingWindowUnorderedMinMaxValue(IItemCollection items, IQuantity windowSize, IQuantity slideSize, final FutureTask<IResult> cancellationSupplier, final IUnorderedWindowValueFunction<V> valueFunction, final Comparator<V> valueComparator, boolean max, boolean includeIntersecting) {
        final ArrayList valueList = new ArrayList();
        SlidingWindowToolkit.slidingWindowUnordered(new IUnorderedWindowVisitor(){

            @Override
            public void visitWindow(IItemCollection items, IQuantity startTime, IQuantity endTime) {
                Object value = valueFunction.getValue(items, startTime, endTime);
                if (value != null) {
                    valueList.add(new Pair(value, (Object)QuantityRange.createWithEnd((IQuantity)startTime, (IQuantity)endTime)));
                }
            }

            @Override
            public boolean shouldContinue() {
                return !cancellationSupplier.isCancelled();
            }
        }, items, windowSize, slideSize, includeIntersecting);
        Comparator comparator = new Comparator<Pair<V, IRange<IQuantity>>>(){

            @Override
            public int compare(Pair<V, IRange<IQuantity>> o1, Pair<V, IRange<IQuantity>> o2) {
                return valueComparator.compare(o1.left, o2.left);
            }
        };
        if (valueList.isEmpty()) {
            return null;
        }
        Pair minMaxWindow = max ? (Pair)Collections.max(valueList, comparator) : (Pair)Collections.min(valueList, comparator);
        return minMaxWindow;
    }

    public static interface IOrderedWindowVisitor {
        public void visitWindow(Iterator<IItem> var1);

        public boolean shouldContinue();
    }

    public static interface IUnorderedWindowVisitor {
        public void visitWindow(IItemCollection var1, IQuantity var2, IQuantity var3);

        public boolean shouldContinue();
    }

    public static interface IUnorderedWindowValueFunction<V> {
        public V getValue(IItemCollection var1, IQuantity var2, IQuantity var3);
    }
}

