/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.file.CleaningPathVisitor;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.TestArguments;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CleaningPathVisitorTest
extends TestArguments {
    @TempDir
    private Path tempDir;

    private void applyCleanEmptyDirectory(CleaningPathVisitor visitor) throws IOException {
        Files.walkFileTree(this.tempDir, (FileVisitor<? super Path>)visitor);
        CounterAssertions.assertCounts(1L, 0L, 0L, (CountingPathVisitor)visitor);
    }

    @ParameterizedTest
    @MethodSource(value={"cleaningPathVisitors"})
    public void testCleanEmptyDirectory(CleaningPathVisitor visitor) throws IOException {
        this.applyCleanEmptyDirectory(visitor);
    }

    @ParameterizedTest
    @MethodSource(value={"pathCounters"})
    public void testCleanEmptyDirectoryNullCtorArg(Counters.PathCounters pathCounters) throws IOException {
        this.applyCleanEmptyDirectory(new CleaningPathVisitor(pathCounters, (String[])null));
    }

    @ParameterizedTest
    @MethodSource(value={"cleaningPathVisitors"})
    public void testCleanFolders1FileSize0(CleaningPathVisitor visitor) throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        CleaningPathVisitor visitFileTree = (CleaningPathVisitor)PathUtils.visitFileTree((FileVisitor)visitor, (Path)this.tempDir);
        CounterAssertions.assertCounts(1L, 1L, 0L, (CountingPathVisitor)visitFileTree);
        Assertions.assertSame((Object)visitor, (Object)visitFileTree);
        Assertions.assertNotEquals((Object)visitFileTree, (Object)CleaningPathVisitor.withLongCounters());
        Assertions.assertNotEquals((int)visitFileTree.hashCode(), (int)CleaningPathVisitor.withLongCounters().hashCode());
        Assertions.assertEquals((Object)visitFileTree, (Object)visitFileTree);
        Assertions.assertEquals((int)visitFileTree.hashCode(), (int)visitFileTree.hashCode());
    }

    @ParameterizedTest
    @MethodSource(value={"cleaningPathVisitors"})
    public void testCleanFolders1FileSize1(CleaningPathVisitor visitor) throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        CleaningPathVisitor visitFileTree = (CleaningPathVisitor)PathUtils.visitFileTree((FileVisitor)visitor, (Path)this.tempDir);
        CounterAssertions.assertCounts(1L, 1L, 1L, (CountingPathVisitor)visitFileTree);
        Assertions.assertSame((Object)visitor, (Object)visitFileTree);
        Assertions.assertNotEquals((Object)visitFileTree, (Object)CleaningPathVisitor.withLongCounters());
        Assertions.assertNotEquals((int)visitFileTree.hashCode(), (int)CleaningPathVisitor.withLongCounters().hashCode());
        Assertions.assertEquals((Object)visitFileTree, (Object)visitFileTree);
        Assertions.assertEquals((int)visitFileTree.hashCode(), (int)visitFileTree.hashCode());
    }

    @ParameterizedTest
    @MethodSource(value={"pathCounters"})
    public void testCleanFolders1FileSize1Skip(Counters.PathCounters pathCounters) throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        String skipFileName = "file-size-1.bin";
        CleaningPathVisitor visitor = new CleaningPathVisitor(pathCounters, new String[]{"file-size-1.bin"});
        CountingPathVisitor visitFileTree = (CountingPathVisitor)PathUtils.visitFileTree((FileVisitor)visitor, (Path)this.tempDir);
        CounterAssertions.assertCounts(1L, 1L, 1L, visitFileTree);
        Assertions.assertSame((Object)visitor, (Object)visitFileTree);
        Path skippedFile = this.tempDir.resolve("file-size-1.bin");
        Assertions.assertTrue((boolean)Files.exists(skippedFile, new LinkOption[0]));
        Files.delete(skippedFile);
        Assertions.assertNotEquals((Object)visitFileTree, (Object)CleaningPathVisitor.withLongCounters());
        Assertions.assertNotEquals((int)visitFileTree.hashCode(), (int)CleaningPathVisitor.withLongCounters().hashCode());
        Assertions.assertEquals((Object)visitFileTree, (Object)visitFileTree);
        Assertions.assertEquals((int)visitFileTree.hashCode(), (int)visitFileTree.hashCode());
    }

    @ParameterizedTest
    @MethodSource(value={"cleaningPathVisitors"})
    public void testCleanFolders2FileSize2(CleaningPathVisitor visitor) throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-2", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        CleaningPathVisitor visitFileTree = (CleaningPathVisitor)PathUtils.visitFileTree((FileVisitor)visitor, (Path)this.tempDir);
        CounterAssertions.assertCounts(3L, 2L, 2L, (CountingPathVisitor)visitFileTree);
        Assertions.assertSame((Object)visitor, (Object)visitFileTree);
        Assertions.assertNotEquals((Object)visitFileTree, (Object)CleaningPathVisitor.withLongCounters());
        Assertions.assertNotEquals((int)visitFileTree.hashCode(), (int)CleaningPathVisitor.withLongCounters().hashCode());
        Assertions.assertEquals((Object)visitFileTree, (Object)visitFileTree);
        Assertions.assertEquals((int)visitFileTree.hashCode(), (int)visitFileTree.hashCode());
    }

    @Test
    public void testEqualsHashCode() {
        CountingPathVisitor visitor0 = CleaningPathVisitor.withLongCounters();
        CountingPathVisitor visitor1 = CleaningPathVisitor.withLongCounters();
        Assertions.assertEquals((Object)visitor0, (Object)visitor0);
        Assertions.assertEquals((Object)visitor0, (Object)visitor1);
        Assertions.assertEquals((Object)visitor1, (Object)visitor0);
        Assertions.assertEquals((int)visitor0.hashCode(), (int)visitor0.hashCode());
        Assertions.assertEquals((int)visitor0.hashCode(), (int)visitor1.hashCode());
        Assertions.assertEquals((int)visitor1.hashCode(), (int)visitor0.hashCode());
        visitor0.getPathCounters().getByteCounter().increment();
        Assertions.assertEquals((Object)visitor0, (Object)visitor0);
        Assertions.assertNotEquals((Object)visitor0, (Object)visitor1);
        Assertions.assertNotEquals((Object)visitor1, (Object)visitor0);
        Assertions.assertEquals((int)visitor0.hashCode(), (int)visitor0.hashCode());
        Assertions.assertNotEquals((int)visitor0.hashCode(), (int)visitor1.hashCode());
        Assertions.assertNotEquals((int)visitor1.hashCode(), (int)visitor0.hashCode());
    }
}

