/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.filefilter.AbstractConditionalFileFilterTest;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.ConditionalFileFilter;
import org.apache.commons.io.filefilter.EmptyFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AndFileFilterTest
extends AbstractConditionalFileFilterTest {
    private static final String DEFAULT_WORKING_PATH = "./AndFileFilterTestCase/";
    private static final String WORKING_PATH_NAME_PROPERTY_KEY = AndFileFilterTest.class.getName() + ".workingDirectory";
    private List<List<IOFileFilter>> testFilters;
    private List<boolean[]> testTrueResults;
    private List<boolean[]> testFalseResults;
    private List<Boolean> testFileResults;
    private List<Boolean> testFilenameResults;

    @Override
    protected IOFileFilter buildFilterUsingAdd(List<IOFileFilter> filters) {
        AndFileFilter filter = new AndFileFilter();
        filters.forEach(arg_0 -> ((AndFileFilter)filter).addFileFilter(arg_0));
        return filter;
    }

    @Override
    protected IOFileFilter buildFilterUsingConstructor(List<IOFileFilter> filters) {
        return new AndFileFilter(filters);
    }

    @Override
    protected ConditionalFileFilter getConditionalFileFilter() {
        return new AndFileFilter();
    }

    @Override
    protected String getDefaultWorkingPath() {
        return DEFAULT_WORKING_PATH;
    }

    @Override
    protected List<boolean[]> getFalseResults() {
        return this.testFalseResults;
    }

    @Override
    protected List<Boolean> getFilenameResults() {
        return this.testFilenameResults;
    }

    @Override
    protected List<Boolean> getFileResults() {
        return this.testFileResults;
    }

    @Override
    protected List<List<IOFileFilter>> getTestFilters() {
        return this.testFilters;
    }

    @Override
    protected List<boolean[]> getTrueResults() {
        return this.testTrueResults;
    }

    @Override
    protected String getWorkingPathNamePropertyKey() {
        return WORKING_PATH_NAME_PROPERTY_KEY;
    }

    @BeforeEach
    public void setUpTestFilters() {
        this.testFilters = new ArrayList<List<IOFileFilter>>();
        this.testTrueResults = new ArrayList<boolean[]>();
        this.testFalseResults = new ArrayList<boolean[]>();
        this.testFileResults = new ArrayList<Boolean>();
        this.testFilenameResults = new ArrayList<Boolean>();
        this.testFilters.add(0, null);
        this.testTrueResults.add(0, null);
        this.testFalseResults.add(0, null);
        this.testFileResults.add(0, null);
        this.testFilenameResults.add(0, null);
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add((Object)this.trueFilters[1]);
        filters.add((Object)this.trueFilters[2]);
        filters.add((Object)this.trueFilters[3]);
        boolean[] trueResults = new boolean[]{true, true, true};
        boolean[] falseResults = new boolean[]{false, false, false};
        this.testFilters.add(1, filters);
        this.testTrueResults.add(1, trueResults);
        this.testFalseResults.add(1, falseResults);
        this.testFileResults.add(1, Boolean.TRUE);
        this.testFilenameResults.add(1, Boolean.TRUE);
        filters = new ArrayList();
        filters.add((Object)this.falseFilters[1]);
        filters.add((Object)this.trueFilters[1]);
        filters.add((Object)this.trueFilters[2]);
        filters.add((Object)this.trueFilters[3]);
        filters.add((Object)this.falseFilters[2]);
        filters.add((Object)this.falseFilters[3]);
        trueResults = new boolean[]{false, false, false};
        falseResults = new boolean[]{true, false, false};
        this.testFilters.add(2, filters);
        this.testTrueResults.add(2, trueResults);
        this.testFalseResults.add(2, falseResults);
        this.testFileResults.add(2, Boolean.FALSE);
        this.testFilenameResults.add(2, Boolean.FALSE);
        filters = new ArrayList();
        filters.add((Object)this.trueFilters[1]);
        filters.add((Object)this.falseFilters[1]);
        filters.add((Object)this.trueFilters[2]);
        filters.add((Object)this.trueFilters[3]);
        filters.add((Object)this.falseFilters[2]);
        filters.add((Object)this.falseFilters[3]);
        trueResults = new boolean[]{true, false, false};
        falseResults = new boolean[]{true, false, false};
        this.testFilters.add(3, filters);
        this.testTrueResults.add(3, trueResults);
        this.testFalseResults.add(3, falseResults);
        this.testFileResults.add(3, Boolean.FALSE);
        this.testFilenameResults.add(3, Boolean.FALSE);
        filters = new ArrayList();
        filters.add((Object)this.trueFilters[1]);
        filters.add((Object)this.trueFilters[2]);
        filters.add((Object)this.falseFilters[1]);
        filters.add((Object)this.trueFilters[3]);
        filters.add((Object)this.falseFilters[2]);
        filters.add((Object)this.falseFilters[3]);
        trueResults = new boolean[]{true, true, false};
        falseResults = new boolean[]{true, false, false};
        this.testFilters.add(4, filters);
        this.testTrueResults.add(4, trueResults);
        this.testFalseResults.add(4, falseResults);
        this.testFileResults.add(4, Boolean.FALSE);
        this.testFilenameResults.add(4, Boolean.FALSE);
        filters = new ArrayList();
        filters.add((Object)this.falseFilters[1]);
        filters.add((Object)this.trueFilters[1]);
        filters.add((Object)this.falseFilters[2]);
        filters.add((Object)this.falseFilters[3]);
        filters.add((Object)this.trueFilters[2]);
        filters.add((Object)this.trueFilters[3]);
        trueResults = new boolean[]{false, false, false};
        falseResults = new boolean[]{true, false, false};
        this.testFilters.add(5, filters);
        this.testTrueResults.add(5, trueResults);
        this.testFalseResults.add(5, falseResults);
        this.testFileResults.add(5, Boolean.FALSE);
        this.testFilenameResults.add(5, Boolean.FALSE);
        filters = new ArrayList();
        filters.add((Object)this.trueFilters[1]);
        filters.add((Object)this.falseFilters[1]);
        filters.add((Object)this.falseFilters[2]);
        filters.add((Object)this.trueFilters[2]);
        filters.add((Object)this.trueFilters[3]);
        filters.add((Object)this.falseFilters[3]);
        trueResults = new boolean[]{true, false, false};
        falseResults = new boolean[]{true, false, false};
        this.testFilters.add(6, filters);
        this.testTrueResults.add(6, trueResults);
        this.testFalseResults.add(6, falseResults);
        this.testFileResults.add(6, Boolean.FALSE);
        this.testFilenameResults.add(6, Boolean.FALSE);
        filters = new ArrayList();
        filters.add((Object)this.falseFilters[1]);
        filters.add((Object)this.falseFilters[2]);
        filters.add((Object)this.trueFilters[3]);
        filters.add((Object)this.falseFilters[3]);
        filters.add((Object)this.trueFilters[2]);
        filters.add((Object)this.trueFilters[3]);
        trueResults = new boolean[]{false, false, false};
        falseResults = new boolean[]{true, false, false};
        this.testFilters.add(7, filters);
        this.testTrueResults.add(7, trueResults);
        this.testFalseResults.add(7, falseResults);
        this.testFileResults.add(7, Boolean.FALSE);
        this.testFilenameResults.add(7, Boolean.FALSE);
        filters = new ArrayList();
        filters.add((Object)this.trueFilters[1]);
        filters.add((Object)this.trueFilters[2]);
        filters.add((Object)this.trueFilters[3]);
        filters.add((Object)this.falseFilters[1]);
        trueResults = new boolean[]{true, true, true};
        falseResults = new boolean[]{true, false, false};
        this.testFilters.add(8, filters);
        this.testTrueResults.add(8, trueResults);
        this.testFalseResults.add(8, falseResults);
        this.testFileResults.add(8, Boolean.FALSE);
        this.testFilenameResults.add(8, Boolean.FALSE);
        filters = new ArrayList();
        filters.add((Object)this.falseFilters[1]);
        filters.add((Object)this.falseFilters[2]);
        filters.add((Object)this.falseFilters[3]);
        trueResults = new boolean[]{false, false, false};
        falseResults = new boolean[]{true, false, false};
        this.testFilters.add(9, filters);
        this.testTrueResults.add(9, trueResults);
        this.testFalseResults.add(9, falseResults);
        this.testFileResults.add(9, Boolean.FALSE);
        this.testFilenameResults.add(9, Boolean.FALSE);
    }

    @Test
    public void testSetTestFiltersClearsOld() {
        List<IOFileFilter> simpleEmptyFileFilter = Collections.singletonList(EmptyFileFilter.EMPTY);
        AndFileFilter andFileFilter = new AndFileFilter(simpleEmptyFileFilter);
        Assertions.assertEquals(simpleEmptyFileFilter, (Object)andFileFilter.getFileFilters());
        List<IOFileFilter> simpleNonEmptyFilter = Collections.singletonList(EmptyFileFilter.NOT_EMPTY);
        andFileFilter.setFileFilters(simpleNonEmptyFilter);
        Assertions.assertEquals(simpleNonEmptyFilter, (Object)andFileFilter.getFileFilters());
    }
}

