/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.function.IOIteratorAdapter;
import org.apache.commons.io.function.TestConstants;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IOIteratorAdapterTest {
    private IOIteratorAdapter<Path> iterator;

    @BeforeEach
    public void beforeEach() {
        this.iterator = IOIteratorAdapter.adapt(this.newPathList().iterator());
    }

    private List<Path> newPathList() {
        return Arrays.asList(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_B);
    }

    @Test
    public void testAdapt() throws IOException {
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, (Object)this.iterator.next());
    }

    @Test
    public void testAsIterator() {
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, this.iterator.asIterator().next());
    }

    @Test
    public void testForEachRemaining() throws IOException {
        ArrayList list = new ArrayList();
        this.iterator.forEachRemaining(p -> list.add(p.toRealPath(new LinkOption[0])));
        Assertions.assertFalse((boolean)this.iterator.hasNext());
        Assertions.assertEquals(this.newPathList(), list);
    }

    @Test
    public void testHasNext() throws IOException {
        Assertions.assertTrue((boolean)this.iterator.hasNext());
        this.iterator.forEachRemaining(rec$ -> ((Path)rec$).toRealPath(new LinkOption[0]));
        Assertions.assertFalse((boolean)this.iterator.hasNext());
    }

    @Test
    public void testNext() throws IOException {
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A, (Object)this.iterator.next());
    }

    @Test
    public void testRemove() throws IOException {
        Class exClass = SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8) ? IllegalStateException.class : UnsupportedOperationException.class;
        Assertions.assertThrows(exClass, () -> this.iterator.remove());
        Assertions.assertThrows(exClass, () -> this.iterator.remove());
        this.iterator.next();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.iterator.remove());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.iterator.remove());
    }
}

