/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.jmh;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Thread)
@Warmup(iterations=5, time=10, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=10, timeUnit=TimeUnit.SECONDS)
@Fork(value=1, jvmArgs={"-server"})
public class IOUtilsContentEqualsInputStreamsBenchmark {
    private static final String TEST_PATH_A = "/org/apache/commons/io/testfileBOM.xml";
    private static final String TEST_PATH_16K_A = "/org/apache/commons/io/abitmorethan16k.txt";
    private static final String TEST_PATH_16K_A_COPY = "/org/apache/commons/io/abitmorethan16kcopy.txt";
    private static final String TEST_PATH_B = "/org/apache/commons/io/testfileNoBOM.xml";
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    static String[] STRINGS = new String[5];
    static String SPECIAL_CASE_STRING_0;
    static String SPECIAL_CASE_STRING_1;

    public static boolean contentEquals_release_2_8_0(InputStream input1, InputStream input2) throws IOException {
        if (input1 == input2) {
            return true;
        }
        if (input1 == null ^ input2 == null) {
            return false;
        }
        BufferedInputStream bufferedInput1 = IOUtils.buffer((InputStream)input1);
        BufferedInputStream bufferedInput2 = IOUtils.buffer((InputStream)input2);
        int ch = bufferedInput1.read();
        while (-1 != ch) {
            int ch2 = bufferedInput2.read();
            if (ch != ch2) {
                return false;
            }
            ch = bufferedInput1.read();
        }
        return bufferedInput2.read() == -1;
    }

    public static boolean contentEqualsPr118(InputStream input1, InputStream input2) throws IOException {
        if (input1 == input2) {
            return true;
        }
        if (input1 == null || input2 == null) {
            return false;
        }
        byte[] array1 = new byte[8192];
        byte[] array2 = new byte[8192];
        block0: while (true) {
            int pos1 = 0;
            int pos2 = 0;
            int index = 0;
            while (true) {
                if (index >= 8192) continue block0;
                if (pos1 == index) {
                    int count1;
                    while ((count1 = input1.read(array1, pos1, 8192 - pos1)) == 0) {
                    }
                    if (count1 == -1) {
                        return pos2 == index && input2.read() == -1;
                    }
                    pos1 += count1;
                }
                if (pos2 == index) {
                    int count2;
                    while ((count2 = input2.read(array2, pos2, 8192 - pos2)) == 0) {
                    }
                    if (count2 == -1) {
                        return pos1 == index && input1.read() == -1;
                    }
                    pos2 += count2;
                }
                if (array1[index] != array2[index]) {
                    return false;
                }
                ++index;
            }
            break;
        }
    }

    @Benchmark
    public boolean[] testFileCurrent() throws IOException {
        InputStream input2;
        boolean[] res = new boolean[3];
        try (InputStream input1 = this.getClass().getResourceAsStream(TEST_PATH_A);){
            input2 = this.getClass().getResourceAsStream(TEST_PATH_B);
            try {
                res[0] = IOUtils.contentEquals((InputStream)input1, (InputStream)input1);
            }
            finally {
                if (input2 != null) {
                    input2.close();
                }
            }
        }
        input1 = this.getClass().getResourceAsStream(TEST_PATH_A);
        try {
            input2 = this.getClass().getResourceAsStream(TEST_PATH_A);
            try {
                res[1] = IOUtils.contentEquals((InputStream)input1, (InputStream)input2);
            }
            finally {
                if (input2 != null) {
                    input2.close();
                }
            }
        }
        finally {
            if (input1 != null) {
                input1.close();
            }
        }
        input1 = this.getClass().getResourceAsStream(TEST_PATH_16K_A);
        try {
            input2 = this.getClass().getResourceAsStream(TEST_PATH_16K_A_COPY);
            try {
                res[2] = IOUtils.contentEquals((InputStream)input1, (InputStream)input2);
            }
            finally {
                if (input2 != null) {
                    input2.close();
                }
            }
        }
        finally {
            if (input1 != null) {
                input1.close();
            }
        }
        return res;
    }

    @Benchmark
    public boolean[] testFilePr118() throws IOException {
        InputStream input2;
        boolean[] res = new boolean[3];
        try (InputStream input1 = this.getClass().getResourceAsStream(TEST_PATH_A);){
            input2 = this.getClass().getResourceAsStream(TEST_PATH_B);
            try {
                res[0] = IOUtilsContentEqualsInputStreamsBenchmark.contentEqualsPr118(input1, input1);
            }
            finally {
                if (input2 != null) {
                    input2.close();
                }
            }
        }
        input1 = this.getClass().getResourceAsStream(TEST_PATH_A);
        try {
            input2 = this.getClass().getResourceAsStream(TEST_PATH_A);
            try {
                res[1] = IOUtilsContentEqualsInputStreamsBenchmark.contentEqualsPr118(input1, input2);
            }
            finally {
                if (input2 != null) {
                    input2.close();
                }
            }
        }
        finally {
            if (input1 != null) {
                input1.close();
            }
        }
        input1 = this.getClass().getResourceAsStream(TEST_PATH_16K_A);
        try {
            input2 = this.getClass().getResourceAsStream(TEST_PATH_16K_A_COPY);
            try {
                res[2] = IOUtilsContentEqualsInputStreamsBenchmark.contentEqualsPr118(input1, input2);
            }
            finally {
                if (input2 != null) {
                    input2.close();
                }
            }
        }
        finally {
            if (input1 != null) {
                input1.close();
            }
        }
        return res;
    }

    @Benchmark
    public boolean[] testFileRelease_2_8_0() throws IOException {
        InputStream input2;
        boolean[] res = new boolean[3];
        try (InputStream input1 = this.getClass().getResourceAsStream(TEST_PATH_A);){
            input2 = this.getClass().getResourceAsStream(TEST_PATH_B);
            try {
                res[0] = IOUtilsContentEqualsInputStreamsBenchmark.contentEquals_release_2_8_0(input1, input1);
            }
            finally {
                if (input2 != null) {
                    input2.close();
                }
            }
        }
        input1 = this.getClass().getResourceAsStream(TEST_PATH_A);
        try {
            input2 = this.getClass().getResourceAsStream(TEST_PATH_A);
            try {
                res[1] = IOUtilsContentEqualsInputStreamsBenchmark.contentEquals_release_2_8_0(input1, input2);
            }
            finally {
                if (input2 != null) {
                    input2.close();
                }
            }
        }
        finally {
            if (input1 != null) {
                input1.close();
            }
        }
        input1 = this.getClass().getResourceAsStream(TEST_PATH_16K_A);
        try {
            input2 = this.getClass().getResourceAsStream(TEST_PATH_16K_A_COPY);
            try {
                res[2] = IOUtilsContentEqualsInputStreamsBenchmark.contentEquals_release_2_8_0(input1, input2);
            }
            finally {
                if (input2 != null) {
                    input2.close();
                }
            }
        }
        finally {
            if (input1 != null) {
                input1.close();
            }
        }
        return res;
    }

    @Benchmark
    public void testStringCurrent(Blackhole blackhole) throws IOException {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                try (InputStream inputReader1 = IOUtils.toInputStream((String)STRINGS[i], (Charset)DEFAULT_CHARSET);
                     InputStream inputReader2 = IOUtils.toInputStream((String)STRINGS[j], (Charset)DEFAULT_CHARSET);){
                    blackhole.consume(IOUtils.contentEquals((InputStream)inputReader1, (InputStream)inputReader2));
                    continue;
                }
            }
        }
    }

    @Benchmark
    public void testStringPr118(Blackhole blackhole) throws IOException {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                try (InputStream input1 = IOUtils.toInputStream((String)STRINGS[i], (Charset)DEFAULT_CHARSET);
                     InputStream input2 = IOUtils.toInputStream((String)STRINGS[j], (Charset)DEFAULT_CHARSET);){
                    blackhole.consume(IOUtilsContentEqualsInputStreamsBenchmark.contentEqualsPr118(input1, input2));
                    continue;
                }
            }
        }
    }

    @Benchmark
    public void testStringRelease_2_8_0(Blackhole blackhole) throws IOException {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                try (InputStream input1 = IOUtils.toInputStream((String)STRINGS[i], (Charset)DEFAULT_CHARSET);
                     InputStream input2 = IOUtils.toInputStream((String)STRINGS[j], (Charset)DEFAULT_CHARSET);){
                    blackhole.consume(IOUtilsContentEqualsInputStreamsBenchmark.contentEquals_release_2_8_0(input1, input2));
                    continue;
                }
            }
        }
    }

    static {
        IOUtilsContentEqualsInputStreamsBenchmark.STRINGS[0] = StringUtils.repeat((String)"ab", (int)0x1000000);
        IOUtilsContentEqualsInputStreamsBenchmark.STRINGS[1] = STRINGS[0] + 'c';
        IOUtilsContentEqualsInputStreamsBenchmark.STRINGS[2] = STRINGS[0] + 'd';
        IOUtilsContentEqualsInputStreamsBenchmark.STRINGS[3] = StringUtils.repeat((String)"ab\rab\n", (int)0x1000000);
        IOUtilsContentEqualsInputStreamsBenchmark.STRINGS[4] = StringUtils.repeat((String)"ab\r\nab\r", (int)0x1000000);
        SPECIAL_CASE_STRING_0 = StringUtils.repeat((String)(StringUtils.repeat((String)"ab", (int)0x1000000) + '\n'), (int)2);
        SPECIAL_CASE_STRING_1 = StringUtils.repeat((String)(StringUtils.repeat((String)"cd", (int)0x1000000) + '\n'), (int)2);
    }
}

