/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.io.ThreadUtils;
import org.apache.commons.io.monitor.AbstractMonitorTest;
import org.apache.commons.io.monitor.CollectionFileListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.io.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileAlterationMonitorTest
extends AbstractMonitorTest {
    public FileAlterationMonitorTest() {
        this.listener = new CollectionFileListener(false);
    }

    private void checkFile(String label, File file, Collection<File> files) {
        for (int i = 0; i < 20; ++i) {
            if (files.contains(file)) {
                return;
            }
            TestUtils.sleepQuietly(100L);
        }
        Assertions.fail((String)(label + " " + file + " not found"));
    }

    @Test
    public void testAddRemoveObservers() {
        FileAlterationObserver[] observers = null;
        FileAlterationMonitor monitor = new FileAlterationMonitor(123L, observers);
        Assertions.assertEquals((long)123L, (long)monitor.getInterval(), (String)"Interval");
        Assertions.assertFalse((boolean)monitor.getObservers().iterator().hasNext(), (String)"Observers[1]");
        observers = new FileAlterationObserver[1];
        monitor = new FileAlterationMonitor(456L, observers);
        Assertions.assertFalse((boolean)monitor.getObservers().iterator().hasNext(), (String)"Observers[2]");
        monitor.addObserver(null);
        Assertions.assertFalse((boolean)monitor.getObservers().iterator().hasNext(), (String)"Observers[3]");
        monitor.removeObserver(null);
        FileAlterationObserver observer = new FileAlterationObserver("foo");
        monitor.addObserver(observer);
        Iterator it = monitor.getObservers().iterator();
        Assertions.assertTrue((boolean)it.hasNext(), (String)"Observers[4]");
        Assertions.assertEquals((Object)observer, it.next(), (String)"Added");
        Assertions.assertFalse((boolean)it.hasNext(), (String)"Observers[5]");
        monitor.removeObserver(observer);
        Assertions.assertFalse((boolean)monitor.getObservers().iterator().hasNext(), (String)"Observers[6]");
    }

    @Test
    public void testCollectionConstructor() {
        this.observer = new FileAlterationObserver("foo");
        List<FileAlterationObserver> observers = Arrays.asList(this.observer);
        FileAlterationMonitor monitor = new FileAlterationMonitor(0L, observers);
        Iterator iterator = monitor.getObservers().iterator();
        Assertions.assertEquals((Object)this.observer, iterator.next());
    }

    @Test
    public void testCollectionConstructorShouldDoNothingWithNullCollection() {
        Collection observers = null;
        FileAlterationMonitor monitor = new FileAlterationMonitor(0L, observers);
        Assertions.assertFalse((boolean)monitor.getObservers().iterator().hasNext());
    }

    @Test
    public void testCollectionConstructorShouldDoNothingWithNullObservers() {
        ArrayList observers = new ArrayList(5);
        FileAlterationMonitor monitor = new FileAlterationMonitor(0L, observers);
        Assertions.assertFalse((boolean)monitor.getObservers().iterator().hasNext());
    }

    @Test
    public void testDefaultConstructor() {
        FileAlterationMonitor monitor = new FileAlterationMonitor();
        Assertions.assertEquals((long)10000L, (long)monitor.getInterval(), (String)"Interval");
    }

    @Test
    public void testMonitor() throws Exception {
        long interval = 100L;
        this.listener.clear();
        FileAlterationMonitor monitor = new FileAlterationMonitor(100L, new FileAlterationObserver[]{this.observer});
        Assertions.assertEquals((long)100L, (long)monitor.getInterval(), (String)"Interval");
        monitor.start();
        Assertions.assertThrows(IllegalStateException.class, () -> monitor.start());
        this.checkCollectionsEmpty("A");
        File file1 = this.touch(new File(this.testDir, "file1.java"));
        this.checkFile("Create", file1, this.listener.getCreatedFiles());
        this.listener.clear();
        this.checkCollectionsEmpty("B");
        file1 = this.touch(file1);
        this.checkFile("Update", file1, this.listener.getChangedFiles());
        this.listener.clear();
        this.checkCollectionsEmpty("C");
        file1.delete();
        this.checkFile("Delete", file1, this.listener.getDeletedFiles());
        this.listener.clear();
        monitor.stop();
        Assertions.assertThrows(IllegalStateException.class, () -> monitor.stop());
    }

    @Test
    public void testStopWhileWaitingForNextInterval() throws Exception {
        final ArrayList createdThreads = new ArrayList(1);
        ThreadFactory threadFactory = new ThreadFactory(){
            private final ThreadFactory delegate = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = this.delegate.newThread(r);
                thread.setDaemon(true);
                createdThreads.add(thread);
                return thread;
            }
        };
        FileAlterationMonitor monitor = new FileAlterationMonitor(1000L);
        monitor.setThreadFactory(threadFactory);
        monitor.start();
        Assertions.assertFalse((boolean)createdThreads.isEmpty());
        ThreadUtils.sleep((Duration)Duration.ofMillis(10L));
        monitor.stop(100L);
        createdThreads.forEach(thread -> Assertions.assertFalse((boolean)thread.isAlive(), (String)"The FileAlterationMonitor did not stop the threads it created."));
    }

    @Test
    public void testThreadFactory() throws Exception {
        long interval = 100L;
        this.listener.clear();
        FileAlterationMonitor monitor = new FileAlterationMonitor(100L, new FileAlterationObserver[]{this.observer});
        monitor.setThreadFactory(Executors.defaultThreadFactory());
        Assertions.assertEquals((long)100L, (long)monitor.getInterval(), (String)"Interval");
        monitor.start();
        this.checkCollectionsEmpty("A");
        File file2 = this.touch(new File(this.testDir, "file2.java"));
        this.checkFile("Create", file2, this.listener.getCreatedFiles());
        this.listener.clear();
        this.checkCollectionsEmpty("B");
        file2.delete();
        this.checkFile("Delete", file2, this.listener.getDeletedFiles());
        this.listener.clear();
        monitor.stop();
    }
}

