/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.io.filefilter.CanReadFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.AbstractMonitorTest;
import org.apache.commons.io.monitor.CollectionFileListener;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileAlterationObserverTest
extends AbstractMonitorTest {
    private static final String PATH_STRING_FIXTURE = "/foo";

    public FileAlterationObserverTest() {
        this.listener = new CollectionFileListener(true);
    }

    protected void checkAndNotify() {
        this.observer.checkAndNotify();
    }

    private String directoryToUnixString(FileAlterationObserver observer) {
        return FilenameUtils.separatorsToUnix((String)observer.getDirectory().toString());
    }

    @Test
    public void testAddRemoveListeners() {
        FileAlterationObserver observer = (FileAlterationObserver)((FileAlterationObserver.Builder)FileAlterationObserver.builder().setFile(PATH_STRING_FIXTURE)).getUnchecked();
        observer.addListener(null);
        Assertions.assertFalse((boolean)observer.getListeners().iterator().hasNext(), (String)"Listeners[1]");
        observer.removeListener(null);
        Assertions.assertFalse((boolean)observer.getListeners().iterator().hasNext(), (String)"Listeners[2]");
        FileAlterationListenerAdaptor listener = new FileAlterationListenerAdaptor();
        observer.addListener((FileAlterationListener)listener);
        Iterator it = observer.getListeners().iterator();
        Assertions.assertTrue((boolean)it.hasNext(), (String)"Listeners[3]");
        Assertions.assertEquals((Object)listener, it.next(), (String)"Added");
        Assertions.assertFalse((boolean)it.hasNext(), (String)"Listeners[4]");
        observer.removeListener((FileAlterationListener)listener);
        Assertions.assertFalse((boolean)observer.getListeners().iterator().hasNext(), (String)"Listeners[5]");
    }

    @Test
    public void testBuilder_File() {
        File file = new File(PATH_STRING_FIXTURE);
        FileAlterationObserver observer = (FileAlterationObserver)((FileAlterationObserver.Builder)FileAlterationObserver.builder().setFile(file)).getUnchecked();
        Assertions.assertEquals((Object)file, (Object)observer.getDirectory());
    }

    @Test
    public void testBuilder_File_FileFilter() {
        File file = new File(PATH_STRING_FIXTURE);
        FileAlterationObserver observer = (FileAlterationObserver)((FileAlterationObserver.Builder)FileAlterationObserver.builder().setFile(file)).setFileFilter((FileFilter)CanReadFileFilter.CAN_READ).getUnchecked();
        Assertions.assertEquals((Object)file, (Object)observer.getDirectory());
        Assertions.assertEquals((Object)CanReadFileFilter.CAN_READ, (Object)observer.getFileFilter());
    }

    @Test
    public void testBuilder_File_FileFilter_IOCase() {
        File file = new File(PATH_STRING_FIXTURE);
        FileAlterationObserver observer = (FileAlterationObserver)((FileAlterationObserver.Builder)FileAlterationObserver.builder().setFile(file)).setFileFilter((FileFilter)CanReadFileFilter.CAN_READ).setIOCase(IOCase.INSENSITIVE).getUnchecked();
        Assertions.assertEquals((Object)file, (Object)observer.getDirectory());
        Assertions.assertEquals((Object)CanReadFileFilter.CAN_READ, (Object)observer.getFileFilter());
        Assertions.assertEquals((Object)NameFileComparator.NAME_INSENSITIVE_COMPARATOR, (Object)observer.getComparator());
    }

    @Test
    public void testBuilder_String() {
        String file = PATH_STRING_FIXTURE;
        FileAlterationObserver observer = (FileAlterationObserver)((FileAlterationObserver.Builder)FileAlterationObserver.builder().setFile(PATH_STRING_FIXTURE)).getUnchecked();
        Assertions.assertEquals((Object)PATH_STRING_FIXTURE, (Object)this.directoryToUnixString(observer));
    }

    @Test
    public void testBuilder_String_FileFilter() {
        String file = PATH_STRING_FIXTURE;
        FileAlterationObserver observer = (FileAlterationObserver)((FileAlterationObserver.Builder)FileAlterationObserver.builder().setFile(PATH_STRING_FIXTURE)).setFileFilter((FileFilter)CanReadFileFilter.CAN_READ).getUnchecked();
        Assertions.assertEquals((Object)PATH_STRING_FIXTURE, (Object)this.directoryToUnixString(observer));
        Assertions.assertEquals((Object)CanReadFileFilter.CAN_READ, (Object)observer.getFileFilter());
    }

    @Test
    public void testBuilder_String_FileFilter_IOCase() {
        String file = PATH_STRING_FIXTURE;
        FileAlterationObserver observer = (FileAlterationObserver)((FileAlterationObserver.Builder)FileAlterationObserver.builder().setFile(PATH_STRING_FIXTURE)).setFileFilter((FileFilter)CanReadFileFilter.CAN_READ).setIOCase(IOCase.INSENSITIVE).getUnchecked();
        Assertions.assertEquals((Object)PATH_STRING_FIXTURE, (Object)this.directoryToUnixString(observer));
        Assertions.assertEquals((Object)CanReadFileFilter.CAN_READ, (Object)observer.getFileFilter());
        Assertions.assertEquals((Object)NameFileComparator.NAME_INSENSITIVE_COMPARATOR, (Object)observer.getComparator());
    }

    @Test
    public void testConstructor_File() {
        File file = new File(PATH_STRING_FIXTURE);
        FileAlterationObserver observer = new FileAlterationObserver(file);
        Assertions.assertEquals((Object)file, (Object)observer.getDirectory());
    }

    @Test
    public void testConstructor_File_FileFilter() {
        File file = new File(PATH_STRING_FIXTURE);
        FileAlterationObserver observer = new FileAlterationObserver(file, (FileFilter)CanReadFileFilter.CAN_READ);
        Assertions.assertEquals((Object)file, (Object)observer.getDirectory());
        Assertions.assertEquals((Object)CanReadFileFilter.CAN_READ, (Object)observer.getFileFilter());
    }

    @Test
    public void testConstructor_File_FileFilter_IOCase() {
        File file = new File(PATH_STRING_FIXTURE);
        FileAlterationObserver observer = new FileAlterationObserver(file, (FileFilter)CanReadFileFilter.CAN_READ, IOCase.INSENSITIVE);
        Assertions.assertEquals((Object)file, (Object)observer.getDirectory());
        Assertions.assertEquals((Object)CanReadFileFilter.CAN_READ, (Object)observer.getFileFilter());
        Assertions.assertEquals((Object)NameFileComparator.NAME_INSENSITIVE_COMPARATOR, (Object)observer.getComparator());
    }

    @Test
    public void testConstructor_String() {
        String file = PATH_STRING_FIXTURE;
        FileAlterationObserver observer = new FileAlterationObserver(PATH_STRING_FIXTURE);
        Assertions.assertEquals((Object)PATH_STRING_FIXTURE, (Object)this.directoryToUnixString(observer));
    }

    @Test
    public void testConstructor_String_FileFilter() {
        String file = PATH_STRING_FIXTURE;
        FileAlterationObserver observer = new FileAlterationObserver(PATH_STRING_FIXTURE, (FileFilter)CanReadFileFilter.CAN_READ);
        Assertions.assertEquals((Object)PATH_STRING_FIXTURE, (Object)this.directoryToUnixString(observer));
        Assertions.assertEquals((Object)CanReadFileFilter.CAN_READ, (Object)observer.getFileFilter());
    }

    @Test
    public void testConstructor_String_FileFilter_IOCase() {
        String file = PATH_STRING_FIXTURE;
        FileAlterationObserver observer = new FileAlterationObserver(PATH_STRING_FIXTURE, (FileFilter)CanReadFileFilter.CAN_READ, IOCase.INSENSITIVE);
        Assertions.assertEquals((Object)PATH_STRING_FIXTURE, (Object)this.directoryToUnixString(observer));
        Assertions.assertEquals((Object)CanReadFileFilter.CAN_READ, (Object)observer.getFileFilter());
        Assertions.assertEquals((Object)NameFileComparator.NAME_INSENSITIVE_COMPARATOR, (Object)observer.getComparator());
    }

    @Test
    public void testDirectory() throws Exception {
        this.checkAndNotify();
        this.checkCollectionsEmpty("A");
        File testDirA = new File(this.testDir, "test-dir-A");
        File testDirB = new File(this.testDir, "test-dir-B");
        File testDirC = new File(this.testDir, "test-dir-C");
        testDirA.mkdir();
        testDirB.mkdir();
        testDirC.mkdir();
        File testDirAFile1 = this.touch(new File(testDirA, "A-file1.java"));
        File testDirAFile2 = this.touch(new File(testDirA, "A-file2.txt"));
        File testDirAFile3 = this.touch(new File(testDirA, "A-file3.java"));
        File testDirAFile4 = this.touch(new File(testDirA, "A-file4.java"));
        File testDirBFile1 = this.touch(new File(testDirB, "B-file1.java"));
        this.checkAndNotify();
        this.checkCollectionSizes("B", 3, 0, 0, 4, 0, 0);
        Assertions.assertTrue((boolean)this.listener.getCreatedDirectories().contains(testDirA), (String)"B testDirA");
        Assertions.assertTrue((boolean)this.listener.getCreatedDirectories().contains(testDirB), (String)"B testDirB");
        Assertions.assertTrue((boolean)this.listener.getCreatedDirectories().contains(testDirC), (String)"B testDirC");
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile1), (String)"B testDirAFile1");
        Assertions.assertFalse((boolean)this.listener.getCreatedFiles().contains(testDirAFile2), (String)"B testDirAFile2");
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile3), (String)"B testDirAFile3");
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile4), (String)"B testDirAFile4");
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirBFile1), (String)"B testDirBFile1");
        this.checkAndNotify();
        this.checkCollectionsEmpty("C");
        testDirAFile4 = this.touch(testDirAFile4);
        FileUtils.deleteDirectory((File)testDirB);
        this.checkAndNotify();
        this.checkCollectionSizes("D", 0, 0, 1, 0, 1, 1);
        Assertions.assertTrue((boolean)this.listener.getDeletedDirectories().contains(testDirB), (String)"D testDirB");
        Assertions.assertTrue((boolean)this.listener.getChangedFiles().contains(testDirAFile4), (String)"D testDirAFile4");
        Assertions.assertTrue((boolean)this.listener.getDeletedFiles().contains(testDirBFile1), (String)"D testDirBFile1");
        FileUtils.deleteDirectory((File)this.testDir);
        this.checkAndNotify();
        this.checkCollectionSizes("E", 0, 0, 2, 0, 0, 3);
        Assertions.assertTrue((boolean)this.listener.getDeletedDirectories().contains(testDirA), (String)"E testDirA");
        Assertions.assertTrue((boolean)this.listener.getDeletedFiles().contains(testDirAFile1), (String)"E testDirAFile1");
        Assertions.assertFalse((boolean)this.listener.getDeletedFiles().contains(testDirAFile2), (String)"E testDirAFile2");
        Assertions.assertTrue((boolean)this.listener.getDeletedFiles().contains(testDirAFile3), (String)"E testDirAFile3");
        Assertions.assertTrue((boolean)this.listener.getDeletedFiles().contains(testDirAFile4), (String)"E testDirAFile4");
        this.testDir.mkdir();
        this.checkAndNotify();
        this.checkCollectionsEmpty("F");
        this.checkAndNotify();
        this.checkCollectionsEmpty("G");
    }

    @Test
    public void testFileCreate() throws IOException {
        this.checkAndNotify();
        this.checkCollectionsEmpty("A");
        File testDirA = new File(this.testDir, "test-dir-A");
        testDirA.mkdir();
        this.testDir = this.touch(this.testDir);
        testDirA = this.touch(testDirA);
        File testDirAFile1 = new File(testDirA, "A-file1.java");
        File testDirAFile2 = this.touch(new File(testDirA, "A-file2.java"));
        File testDirAFile3 = new File(testDirA, "A-file3.java");
        File testDirAFile4 = this.touch(new File(testDirA, "A-file4.java"));
        File testDirAFile5 = new File(testDirA, "A-file5.java");
        this.checkAndNotify();
        this.checkCollectionSizes("B", 1, 0, 0, 2, 0, 0);
        Assertions.assertFalse((boolean)this.listener.getCreatedFiles().contains(testDirAFile1), (String)"B testDirAFile1");
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile2), (String)"B testDirAFile2");
        Assertions.assertFalse((boolean)this.listener.getCreatedFiles().contains(testDirAFile3), (String)"B testDirAFile3");
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile4), (String)"B testDirAFile4");
        Assertions.assertFalse((boolean)this.listener.getCreatedFiles().contains(testDirAFile5), (String)"B testDirAFile5");
        Assertions.assertFalse((boolean)testDirAFile1.exists(), (String)"B testDirAFile1 exists");
        Assertions.assertTrue((boolean)testDirAFile2.exists(), (String)"B testDirAFile2 exists");
        Assertions.assertFalse((boolean)testDirAFile3.exists(), (String)"B testDirAFile3 exists");
        Assertions.assertTrue((boolean)testDirAFile4.exists(), (String)"B testDirAFile4 exists");
        Assertions.assertFalse((boolean)testDirAFile5.exists(), (String)"B testDirAFile5 exists");
        this.checkAndNotify();
        this.checkCollectionsEmpty("C");
        testDirAFile1 = this.touch(testDirAFile1);
        testDirA = this.touch(testDirA);
        this.checkAndNotify();
        this.checkCollectionSizes("D", 0, 1, 0, 1, 0, 0);
        Assertions.assertTrue((boolean)testDirAFile1.exists(), (String)"D testDirAFile1 exists");
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile1), (String)"D testDirAFile1");
        testDirAFile3 = this.touch(testDirAFile3);
        testDirA = this.touch(testDirA);
        this.checkAndNotify();
        this.checkCollectionSizes("E", 0, 1, 0, 1, 0, 0);
        Assertions.assertTrue((boolean)testDirAFile3.exists(), (String)"E testDirAFile3 exists");
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile3), (String)"E testDirAFile3");
        testDirAFile5 = this.touch(testDirAFile5);
        testDirA = this.touch(testDirA);
        this.checkAndNotify();
        this.checkCollectionSizes("F", 0, 1, 0, 1, 0, 0);
        Assertions.assertTrue((boolean)testDirAFile5.exists(), (String)"F testDirAFile5 exists");
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile5), (String)"F testDirAFile5");
    }

    @Test
    public void testFileDelete() throws IOException {
        this.checkAndNotify();
        this.checkCollectionsEmpty("A");
        File testDirA = new File(this.testDir, "test-dir-A");
        testDirA.mkdir();
        this.testDir = this.touch(this.testDir);
        testDirA = this.touch(testDirA);
        File testDirAFile1 = this.touch(new File(testDirA, "A-file1.java"));
        File testDirAFile2 = this.touch(new File(testDirA, "A-file2.java"));
        File testDirAFile3 = this.touch(new File(testDirA, "A-file3.java"));
        File testDirAFile4 = this.touch(new File(testDirA, "A-file4.java"));
        File testDirAFile5 = this.touch(new File(testDirA, "A-file5.java"));
        Assertions.assertTrue((boolean)testDirAFile1.exists(), (String)"B testDirAFile1 exists");
        Assertions.assertTrue((boolean)testDirAFile2.exists(), (String)"B testDirAFile2 exists");
        Assertions.assertTrue((boolean)testDirAFile3.exists(), (String)"B testDirAFile3 exists");
        Assertions.assertTrue((boolean)testDirAFile4.exists(), (String)"B testDirAFile4 exists");
        Assertions.assertTrue((boolean)testDirAFile5.exists(), (String)"B testDirAFile5 exists");
        this.checkAndNotify();
        this.checkCollectionSizes("B", 1, 0, 0, 5, 0, 0);
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile1), (String)"B testDirAFile1");
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile2), (String)"B testDirAFile2");
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile3), (String)"B testDirAFile3");
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile4), (String)"B testDirAFile4");
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile5), (String)"B testDirAFile5");
        this.checkAndNotify();
        this.checkCollectionsEmpty("C");
        FileUtils.deleteQuietly((File)testDirAFile1);
        testDirA = this.touch(testDirA);
        this.checkAndNotify();
        this.checkCollectionSizes("D", 0, 1, 0, 0, 0, 1);
        Assertions.assertFalse((boolean)testDirAFile1.exists(), (String)"D testDirAFile1 exists");
        Assertions.assertTrue((boolean)this.listener.getDeletedFiles().contains(testDirAFile1), (String)"D testDirAFile1");
        FileUtils.deleteQuietly((File)testDirAFile3);
        testDirA = this.touch(testDirA);
        this.checkAndNotify();
        this.checkCollectionSizes("E", 0, 1, 0, 0, 0, 1);
        Assertions.assertFalse((boolean)testDirAFile3.exists(), (String)"E testDirAFile3 exists");
        Assertions.assertTrue((boolean)this.listener.getDeletedFiles().contains(testDirAFile3), (String)"E testDirAFile3");
        FileUtils.deleteQuietly((File)testDirAFile5);
        testDirA = this.touch(testDirA);
        this.checkAndNotify();
        this.checkCollectionSizes("F", 0, 1, 0, 0, 0, 1);
        Assertions.assertFalse((boolean)testDirAFile5.exists(), (String)"F testDirAFile5 exists");
        Assertions.assertTrue((boolean)this.listener.getDeletedFiles().contains(testDirAFile5), (String)"F testDirAFile5");
    }

    @Test
    public void testFileUpdate() throws IOException {
        this.checkAndNotify();
        this.checkCollectionsEmpty("A");
        File testDirA = new File(this.testDir, "test-dir-A");
        testDirA.mkdir();
        this.testDir = this.touch(this.testDir);
        testDirA = this.touch(testDirA);
        File testDirAFile1 = this.touch(new File(testDirA, "A-file1.java"));
        File testDirAFile2 = this.touch(new File(testDirA, "A-file2.java"));
        File testDirAFile3 = this.touch(new File(testDirA, "A-file3.java"));
        File testDirAFile4 = this.touch(new File(testDirA, "A-file4.java"));
        File testDirAFile5 = this.touch(new File(testDirA, "A-file5.java"));
        this.checkAndNotify();
        this.checkCollectionSizes("B", 1, 0, 0, 5, 0, 0);
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile1), (String)"B testDirAFile1");
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile2), (String)"B testDirAFile2");
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile3), (String)"B testDirAFile3");
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile4), (String)"B testDirAFile4");
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile5), (String)"B testDirAFile5");
        Assertions.assertTrue((boolean)testDirAFile1.exists(), (String)"B testDirAFile1 exists");
        Assertions.assertTrue((boolean)testDirAFile2.exists(), (String)"B testDirAFile2 exists");
        Assertions.assertTrue((boolean)testDirAFile3.exists(), (String)"B testDirAFile3 exists");
        Assertions.assertTrue((boolean)testDirAFile4.exists(), (String)"B testDirAFile4 exists");
        Assertions.assertTrue((boolean)testDirAFile5.exists(), (String)"B testDirAFile5 exists");
        this.checkAndNotify();
        this.checkCollectionsEmpty("C");
        testDirAFile1 = this.touch(testDirAFile1);
        testDirA = this.touch(testDirA);
        this.checkAndNotify();
        this.checkCollectionSizes("D", 0, 1, 0, 0, 1, 0);
        Assertions.assertTrue((boolean)this.listener.getChangedFiles().contains(testDirAFile1), (String)"D testDirAFile1");
        testDirAFile3 = this.touch(testDirAFile3);
        testDirA = this.touch(testDirA);
        this.checkAndNotify();
        this.checkCollectionSizes("E", 0, 1, 0, 0, 1, 0);
        Assertions.assertTrue((boolean)this.listener.getChangedFiles().contains(testDirAFile3), (String)"E testDirAFile3");
        testDirAFile5 = this.touch(testDirAFile5);
        testDirA = this.touch(testDirA);
        this.checkAndNotify();
        this.checkCollectionSizes("F", 0, 1, 0, 0, 1, 0);
        Assertions.assertTrue((boolean)this.listener.getChangedFiles().contains(testDirAFile5), (String)"F testDirAFile5");
    }

    @Test
    public void testObserveSingleFile() throws IOException {
        File testDirA = new File(this.testDir, "test-dir-A");
        File testDirAFile1 = new File(testDirA, "A-file1.java");
        testDirA.mkdir();
        IOFileFilter nameFilter = FileFilterUtils.nameFileFilter((String)testDirAFile1.getName());
        this.createObserver(testDirA, (FileFilter)nameFilter);
        this.checkAndNotify();
        this.checkCollectionsEmpty("A");
        Assertions.assertFalse((boolean)testDirAFile1.exists(), (String)"A testDirAFile1 exists");
        testDirAFile1 = this.touch(testDirAFile1);
        File testDirAFile2 = this.touch(new File(testDirA, "A-file2.txt"));
        File testDirAFile3 = this.touch(new File(testDirA, "A-file3.java"));
        Assertions.assertTrue((boolean)testDirAFile1.exists(), (String)"B testDirAFile1 exists");
        Assertions.assertTrue((boolean)testDirAFile2.exists(), (String)"B testDirAFile2 exists");
        Assertions.assertTrue((boolean)testDirAFile3.exists(), (String)"B testDirAFile3 exists");
        this.checkAndNotify();
        this.checkCollectionSizes("C", 0, 0, 0, 1, 0, 0);
        Assertions.assertTrue((boolean)this.listener.getCreatedFiles().contains(testDirAFile1), (String)"C created");
        Assertions.assertFalse((boolean)this.listener.getCreatedFiles().contains(testDirAFile2), (String)"C created");
        Assertions.assertFalse((boolean)this.listener.getCreatedFiles().contains(testDirAFile3), (String)"C created");
        testDirAFile1 = this.touch(testDirAFile1);
        testDirAFile2 = this.touch(testDirAFile2);
        testDirAFile3 = this.touch(testDirAFile3);
        this.checkAndNotify();
        this.checkCollectionSizes("D", 0, 0, 0, 0, 1, 0);
        Assertions.assertTrue((boolean)this.listener.getChangedFiles().contains(testDirAFile1), (String)"D changed");
        Assertions.assertFalse((boolean)this.listener.getChangedFiles().contains(testDirAFile2), (String)"D changed");
        Assertions.assertFalse((boolean)this.listener.getChangedFiles().contains(testDirAFile3), (String)"D changed");
        FileUtils.deleteQuietly((File)testDirAFile1);
        FileUtils.deleteQuietly((File)testDirAFile2);
        FileUtils.deleteQuietly((File)testDirAFile3);
        Assertions.assertFalse((boolean)testDirAFile1.exists(), (String)"E testDirAFile1 exists");
        Assertions.assertFalse((boolean)testDirAFile2.exists(), (String)"E testDirAFile2 exists");
        Assertions.assertFalse((boolean)testDirAFile3.exists(), (String)"E testDirAFile3 exists");
        this.checkAndNotify();
        this.checkCollectionSizes("E", 0, 0, 0, 0, 0, 1);
        Assertions.assertTrue((boolean)this.listener.getDeletedFiles().contains(testDirAFile1), (String)"E deleted");
        Assertions.assertFalse((boolean)this.listener.getDeletedFiles().contains(testDirAFile2), (String)"E deleted");
        Assertions.assertFalse((boolean)this.listener.getDeletedFiles().contains(testDirAFile3), (String)"E deleted");
    }

    @Test
    public void testToString() {
        File file = new File(PATH_STRING_FIXTURE);
        FileAlterationObserver.Builder builder = FileAlterationObserver.builder();
        FileAlterationObserver observer = (FileAlterationObserver)((FileAlterationObserver.Builder)builder.setFile(file)).getUnchecked();
        Assertions.assertEquals((Object)("FileAlterationObserver[file='" + file.getPath() + "', true, listeners=0]"), (Object)observer.toString());
        observer = (FileAlterationObserver)builder.setFileFilter((FileFilter)CanReadFileFilter.CAN_READ).getUnchecked();
        Assertions.assertEquals((Object)("FileAlterationObserver[file='" + file.getPath() + "', CanReadFileFilter, listeners=0]"), (Object)observer.toString());
        Assertions.assertEquals((Object)file, (Object)observer.getDirectory());
    }
}

