/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.io.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileWriterWithEncodingTest {
    @TempDir
    public File temporaryFolder;
    private String defaultEncoding;
    private File file1;
    private File file2;
    private String textContent;
    private final char[] anotherTestContent = new char[]{'f', 'z', 'x'};

    @BeforeEach
    public void setUp() throws Exception {
        File encodingFinder = new File(this.temporaryFolder, "finder.txt");
        try (OutputStreamWriter out = new OutputStreamWriter(Files.newOutputStream(encodingFinder.toPath(), new OpenOption[0]));){
            this.defaultEncoding = out.getEncoding();
        }
        this.file1 = new File(this.temporaryFolder, "testfile1.txt");
        this.file2 = new File(this.temporaryFolder, "testfile2.txt");
        char[] arr = new char[1024];
        char[] chars = "ABCDEFGHIJKLMNOPQabcdefgihklmnopq".toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = chars[i % chars.length];
        }
        this.textContent = new String(arr);
    }

    private void successfulRun(FileWriterWithEncoding fw21) throws Exception {
        try (FileWriter fw1 = new FileWriter(this.file1);
             FileWriterWithEncoding fw2 = fw21;){
            this.writeTestPayload(fw1, fw2);
            TestUtils.checkFile(this.file1, this.file2);
        }
        Assertions.assertTrue((boolean)this.file1.exists());
        Assertions.assertTrue((boolean)this.file2.exists());
    }

    @Test
    public void testConstructor_File_directory() {
        Assertions.assertThrows(IOException.class, () -> {
            FileWriterWithEncoding writer = new FileWriterWithEncoding(this.temporaryFolder, this.defaultEncoding);
            writer.close();
        });
        Assertions.assertFalse((boolean)this.file1.exists());
        Assertions.assertThrows(IOException.class, () -> {
            FileWriterWithEncoding writer = ((FileWriterWithEncoding.Builder)((FileWriterWithEncoding.Builder)FileWriterWithEncoding.builder().setFile(this.temporaryFolder)).setCharset(this.defaultEncoding)).get();
            if (writer != null) {
                writer.close();
            }
        });
        Assertions.assertFalse((boolean)this.file1.exists());
    }

    @Test
    public void testConstructor_File_encoding_badEncoding() {
        Assertions.assertThrows(IOException.class, () -> {
            FileWriterWithEncoding writer = new FileWriterWithEncoding(this.file1, "BAD-ENCODE");
            writer.close();
        });
        Assertions.assertFalse((boolean)this.file1.exists());
    }

    @Test
    public void testConstructor_File_existingFile_withContent() throws Exception {
        try (FileWriter fw1 = new FileWriter(this.file1);){
            fw1.write(this.textContent);
            fw1.write(65);
        }
        Assertions.assertEquals((long)1025L, (long)this.file1.length());
        fw1 = new FileWriterWithEncoding(this.file1, this.defaultEncoding);
        try {
            fw1.write("ABcd");
        }
        finally {
            fw1.close();
        }
        Assertions.assertEquals((long)4L, (long)this.file1.length());
        fw1 = ((FileWriterWithEncoding.Builder)((FileWriterWithEncoding.Builder)FileWriterWithEncoding.builder().setFile(this.file1)).setCharset(this.defaultEncoding)).get();
        try {
            fw1.write("ABcd");
        }
        finally {
            if (fw1 != null) {
                fw1.close();
            }
        }
        Assertions.assertEquals((long)4L, (long)this.file1.length());
    }

    @Test
    public void testConstructor_File_nullFile() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            FileWriterWithEncoding writer = new FileWriterWithEncoding((File)null, this.defaultEncoding);
            writer.close();
        });
        Assertions.assertFalse((boolean)this.file1.exists());
    }

    @Test
    public void testConstructor_fileName_nullFile() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            FileWriterWithEncoding writer = new FileWriterWithEncoding((String)null, this.defaultEncoding);
            writer.close();
        });
        Assertions.assertFalse((boolean)this.file1.exists());
    }

    @Test
    public void testConstructorAppend_File_existingFile_withContent() throws Exception {
        try (FileWriter fw1 = new FileWriter(this.file1);){
            fw1.write("ABcd");
        }
        Assertions.assertEquals((long)4L, (long)this.file1.length());
        fw1 = new FileWriterWithEncoding(this.file1, this.defaultEncoding, true);
        try {
            fw1.write("XyZ");
        }
        finally {
            fw1.close();
        }
        Assertions.assertEquals((long)7L, (long)this.file1.length());
        fw1 = ((FileWriterWithEncoding.Builder)((FileWriterWithEncoding.Builder)FileWriterWithEncoding.builder().setFile(this.file1)).setCharset(this.defaultEncoding)).setAppend(true).get();
        try {
            fw1.write("XyZ");
        }
        finally {
            if (fw1 != null) {
                fw1.close();
            }
        }
        Assertions.assertEquals((long)10L, (long)this.file1.length());
    }

    @Test
    public void testDifferentEncoding() throws Exception {
        FileWriterWithEncoding fw2;
        FileWriter fw1;
        if (Charset.isSupported(StandardCharsets.UTF_16BE.name())) {
            fw1 = new FileWriter(this.file1);
            try {
                fw2 = new FileWriterWithEncoding(this.file2, this.defaultEncoding);
                try {
                    this.writeTestPayload(fw1, fw2);
                    try {
                        TestUtils.checkFile(this.file1, this.file2);
                        Assertions.fail();
                    }
                    catch (AssertionError assertionError) {
                        // empty catch block
                    }
                }
                finally {
                    fw2.close();
                }
            }
            finally {
                fw1.close();
            }
            Assertions.assertTrue((boolean)this.file1.exists());
            Assertions.assertTrue((boolean)this.file2.exists());
        }
        if (Charset.isSupported(StandardCharsets.UTF_16LE.name())) {
            fw1 = new FileWriter(this.file1);
            try {
                fw2 = new FileWriterWithEncoding(this.file2, this.defaultEncoding);
                try {
                    this.writeTestPayload(fw1, fw2);
                    try {
                        TestUtils.checkFile(this.file1, this.file2);
                        Assertions.fail();
                    }
                    catch (AssertionError assertionError) {
                        // empty catch block
                    }
                }
                finally {
                    fw2.close();
                }
            }
            finally {
                fw1.close();
            }
            Assertions.assertTrue((boolean)this.file1.exists());
            Assertions.assertTrue((boolean)this.file2.exists());
        }
    }

    @Test
    public void testSameEncoding_Charset_constructor() throws Exception {
        try (FileWriterWithEncoding writer = new FileWriterWithEncoding(this.file2, Charset.defaultCharset());){
            this.successfulRun(writer);
        }
        writer = ((FileWriterWithEncoding.Builder)((FileWriterWithEncoding.Builder)FileWriterWithEncoding.builder().setFile(this.file2)).setCharset(Charset.defaultCharset())).get();
        try {
            this.successfulRun(writer);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Test
    public void testSameEncoding_CharsetEncoder_constructor() throws Exception {
        try (FileWriterWithEncoding writer = new FileWriterWithEncoding(this.file2, Charset.defaultCharset().newEncoder());){
            this.successfulRun(writer);
        }
        writer = ((FileWriterWithEncoding.Builder)FileWriterWithEncoding.builder().setFile(this.file2)).setCharsetEncoder(Charset.defaultCharset().newEncoder()).get();
        try {
            this.successfulRun(writer);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Test
    public void testSameEncoding_null_Charset_constructor() throws Exception {
        try (FileWriterWithEncoding writer = new FileWriterWithEncoding(this.file2, (Charset)null);){
            this.successfulRun(writer);
        }
    }

    @Test
    public void testSameEncoding_null_CharsetEncoder_constructor() throws Exception {
        try (FileWriterWithEncoding writer = new FileWriterWithEncoding(this.file2.getPath(), (CharsetEncoder)null);){
            this.successfulRun(writer);
        }
        writer = ((FileWriterWithEncoding.Builder)FileWriterWithEncoding.builder().setFile(this.file2.getPath())).get();
        try {
            this.successfulRun(writer);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        writer = ((FileWriterWithEncoding.Builder)FileWriterWithEncoding.builder().setFile(this.file2.getPath())).setCharsetEncoder(null).get();
        try {
            this.successfulRun(writer);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Test
    public void testSameEncoding_null_CharsetName_constructor() throws Exception {
        try (FileWriterWithEncoding writer = new FileWriterWithEncoding(this.file2.getPath(), (String)null);){
            this.successfulRun(writer);
        }
    }

    @Test
    public void testSameEncoding_string_Charset_constructor() throws Exception {
        try (FileWriterWithEncoding writer = new FileWriterWithEncoding(this.file2.getPath(), Charset.defaultCharset());){
            this.successfulRun(writer);
        }
        writer = ((FileWriterWithEncoding.Builder)((FileWriterWithEncoding.Builder)FileWriterWithEncoding.builder().setFile(this.file2.getPath())).setCharset(Charset.defaultCharset())).get();
        try {
            this.successfulRun(writer);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Test
    public void testSameEncoding_string_CharsetEncoder_constructor() throws Exception {
        try (FileWriterWithEncoding writer = new FileWriterWithEncoding(this.file2.getPath(), Charset.defaultCharset().newEncoder());){
            this.successfulRun(writer);
        }
    }

    @Test
    public void testSameEncoding_string_constructor() throws Exception {
        try (FileWriterWithEncoding writer = new FileWriterWithEncoding(this.file2, this.defaultEncoding);){
            this.successfulRun(writer);
        }
    }

    @Test
    public void testSameEncoding_string_string_constructor() throws Exception {
        try (FileWriterWithEncoding writer = new FileWriterWithEncoding(this.file2.getPath(), this.defaultEncoding);){
            this.successfulRun(writer);
        }
        writer = ((FileWriterWithEncoding.Builder)((FileWriterWithEncoding.Builder)FileWriterWithEncoding.builder().setFile(this.file2.getPath())).setCharset(this.defaultEncoding)).get();
        try {
            this.successfulRun(writer);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void writeTestPayload(FileWriter fw1, FileWriterWithEncoding fw2) throws IOException {
        Assertions.assertTrue((boolean)this.file1.exists());
        Assertions.assertTrue((boolean)this.file2.exists());
        fw1.write(this.textContent);
        fw2.write(this.textContent);
        fw1.write(65);
        fw2.write(65);
        fw1.write(this.anotherTestContent);
        fw2.write(this.anotherTestContent);
        fw1.write(this.anotherTestContent, 1, 2);
        fw2.write(this.anotherTestContent, 1, 2);
        fw1.write("CAFE", 1, 2);
        fw2.write("CAFE", 1, 2);
        fw1.flush();
        fw2.flush();
    }
}

