/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.core.ui;

import java.awt.Font;
import java.awt.FontMetrics;

public enum StringClipper {
    NONE{

        @Override
        public String clipString(Font font, FontMetrics metrics, double availTextWidth, String text, String clipString) {
            return text;
        }
    }
    ,
    RIGHT{

        @Override
        public String clipString(Font font, FontMetrics metrics, double availTextWidth, String text, String clipString) {
            if ((availTextWidth -= font.getStringBounds(clipString, metrics.getFontRenderContext()).getWidth()) <= 0.0) {
                return clipString;
            }
            int stringLength = text.length();
            int width = 0;
            for (int nChars = 0; nChars < stringLength; ++nChars) {
                if (!((double)(width += metrics.charWidth(text.charAt(nChars))) > availTextWidth)) continue;
                text = text.substring(0, nChars);
                break;
            }
            return text + clipString;
        }
    };

    public static final String LONG_TEXT_PLACEHOLDER = "\u2026";

    public abstract String clipString(Font var1, FontMetrics var2, double var3, String var5, String var6);

    public String clipString(Font font, FontMetrics metrics, double availTextWidth, String text) {
        return this.clipString(font, metrics, availTextWidth, text, LONG_TEXT_PLACEHOLDER);
    }
}

