/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rcp.application;

import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.openjdk.jmc.rcp.application.BasicFile;
import org.openjdk.jmc.ui.common.idesupport.IIDESupport;
import org.openjdk.jmc.ui.common.resource.MCFile;
import org.openjdk.jmc.ui.idesupport.IDESupportUIToolkit;

public class RCPApplicationIDESupport
implements IIDESupport {
    public MCFile browseForSaveAsFile(String title, String suggestedFile, String fileExtension, String description) {
        File file = IDESupportUIToolkit.browseForSaveAsFile((String)title, (File)new File(suggestedFile), (String)fileExtension, (String)description);
        return file == null ? null : new BasicFile(file.getPath());
    }

    public String getIdentity() {
        return "org.openjdk.jmc.rcp";
    }

    public MCFile createFileResource(String path) {
        return new BasicFile(path);
    }

    public MCFile createDefaultFileResource(String resourcePath) throws IllegalArgumentException {
        return this.createFileResource(resourcePath);
    }

    public IPath getDefaultRecordingFolder() {
        String userHome = System.getProperty("user.home");
        return userHome == null ? null : Path.fromOSString((String)userHome);
    }

    public File resolveFileSystemPath(String resourcePath) throws FileNotFoundException {
        File absoultePath = BasicFile.makeAbsolute(resourcePath);
        if (absoultePath.exists()) {
            return absoultePath;
        }
        throw new FileNotFoundException(resourcePath);
    }

    public IStatus validateFileResourcePath(String resourcePath) throws IllegalArgumentException {
        File absolutePath = BasicFile.makeAbsolute(resourcePath);
        if (absolutePath.getParentFile() == null) {
            return IIDESupport.FILE_PATH_IS_A_FOLDER;
        }
        if (!absolutePath.exists()) {
            return Status.OK_STATUS;
        }
        if (absolutePath.isFile()) {
            return IIDESupport.FILE_EXISTS_STATUS;
        }
        return IIDESupport.FILE_PATH_IS_A_FOLDER;
    }
}

