/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rcp.application.scripting.actions;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.Action;
import org.openjdk.jmc.rcp.application.scripting.model.OperatingSystem;
import org.openjdk.jmc.rcp.application.scripting.model.Process;

public abstract class ProcessAction
extends Action {
    private final OperatingSystem m_os;

    ProcessAction(OperatingSystem os, String text, int style) {
        super(text, style);
        this.m_os = os;
        this.updateStatus();
        this.hookProcessListener();
    }

    public abstract void run();

    protected abstract void updateStatus();

    protected final OperatingSystem getOperatingSystem() {
        return this.m_os;
    }

    private void hookProcessListener() {
        Process process = this.m_os.getProcessInFocus();
        process.addObserver(new Observer(){

            @Override
            public void update(Observable arg0, Object arg1) {
                ProcessAction.this.updateStatus();
            }
        });
    }

    protected final Process getProcess() {
        return this.m_os.getProcessInFocus();
    }
}

