/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.internal;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.common.subscription.IMRIService;
import org.openjdk.jmc.rjmx.common.subscription.MRI;
import org.openjdk.jmc.rjmx.ui.RJMXUIPlugin;
import org.openjdk.jmc.rjmx.ui.internal.AttributeSelectionViewModel;
import org.openjdk.jmc.rjmx.ui.internal.AttributeSelectorWizardDialog;
import org.openjdk.jmc.rjmx.ui.internal.IAttributeSet;
import org.openjdk.jmc.rjmx.ui.internal.Messages;

public class AddAttibutesAction
extends Action {
    private static final MRI[] EMPTY = new MRI[0];
    private final IMRIService availableAttributes;
    private final IMRIMetadataService mds;
    private final IAttributeSet attributSet;
    private final boolean numericalsOnly;

    public AddAttibutesAction(IMRIMetadataService mds, IMRIService availableAttributes, IAttributeSet attributSet) {
        this(mds, availableAttributes, attributSet, true);
    }

    public AddAttibutesAction(IMRIMetadataService mds, IMRIService availableAttributes, IAttributeSet attributSet, boolean numericalsOnly) {
        super(Messages.ADD_ATTIBUTES_ACTION_TEXT, RJMXUIPlugin.getDefault().getMCImageDescriptor("add-obj.gif"));
        this.attributSet = attributSet;
        this.numericalsOnly = numericalsOnly;
        this.setToolTipText(Messages.ADD_ATTIBUTES_ACTION_TOOLTIP);
        this.setDisabledImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("add-obj-off.gif"));
        this.setId("add");
        this.mds = mds;
        this.availableAttributes = availableAttributes;
    }

    public void run() {
        AttributeSelectionViewModel viewModel = this.allowMultiple() ? this.createSelectSeveralAttributesViewModel() : this.createSelectOneAttributeViewModel();
        AttributeSelectorWizardDialog d = new AttributeSelectorWizardDialog(Display.getCurrent().getActiveShell(), viewModel);
        if (d.open(this.availableAttributes, this.mds, EMPTY, (MRI[])this.attributSet.elements()) == 0) {
            this.attributSet.add(d.getSelectedAttributes());
            return;
        }
    }

    private AttributeSelectionViewModel createSelectOneAttributeViewModel() {
        return new AttributeSelectionViewModel(this.getContentType(), false, this.numericalsOnly, org.openjdk.jmc.rjmx.ui.messages.internal.Messages.SELECT_ATTRIBUTE_TITLE, org.openjdk.jmc.rjmx.ui.messages.internal.Messages.SELECT_ATTRIBUTE_TITLE, org.openjdk.jmc.rjmx.ui.messages.internal.Messages.SELECT_ATTRIBUTE_DESCRIPTION, org.openjdk.jmc.rjmx.ui.messages.internal.Messages.CONFIGURE_ATTRIBUTE_TITLE, org.openjdk.jmc.rjmx.ui.messages.internal.Messages.CONFIGURE_ATTRIBUTE_DESCRIPTION);
    }

    private AttributeSelectionViewModel createSelectSeveralAttributesViewModel() {
        return new AttributeSelectionViewModel(this.getContentType(), this.allowMultiple(), this.numericalsOnly, org.openjdk.jmc.rjmx.ui.messages.internal.Messages.SELECT_ATTRIBUTES_TITLE, org.openjdk.jmc.rjmx.ui.messages.internal.Messages.SELECT_ATTRIBUTES_TITLE, org.openjdk.jmc.rjmx.ui.messages.internal.Messages.SELECT_ATTRIBUTES_DESCRIPTION, org.openjdk.jmc.rjmx.ui.messages.internal.Messages.CONFIGURE_ATTRIBUTES_TITLE, org.openjdk.jmc.rjmx.ui.messages.internal.Messages.CONFIGURE_ATTRIBUTES_DESCRIPTION);
    }

    protected ContentType<?> getContentType() {
        return null;
    }

    protected boolean allowMultiple() {
        return true;
    }
}

