/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.openjdk.jmc.rjmx.ui.internal.RemoveAction;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.misc.MCSectionPart;

public class SectionPartManager {
    private final Composite m_container;
    private final IManagedForm m_managedForm;

    public SectionPartManager(IManagedForm managedForm) {
        this.m_managedForm = managedForm;
        this.m_container = managedForm.getForm().getBody();
        this.m_container.setLayout((Layout)new GridLayout());
    }

    public void add(MCSectionPart part, boolean grab, boolean enableRemove) throws IllegalArgumentException {
        this.m_managedForm.addPart((IFormPart)part);
        if (grab) {
            MCLayoutFactory.addGrabOnExpandLayoutData((Section)part.getSection());
        } else {
            part.getSection().setLayoutData((Object)new GridData(4, 4, true, false));
        }
        if (enableRemove) {
            part.getMCToolBarManager().add((IAction)new RemoveAction(this, part), 40);
        }
        part.refresh();
        this.m_managedForm.reflow(true);
    }

    public List<IFormPart> getParts() {
        ArrayList<IFormPart> list = new ArrayList<IFormPart>();
        list.addAll(Arrays.asList(this.m_managedForm.getParts()));
        return Collections.unmodifiableList(list);
    }

    public void destroyAllParts() {
        while (this.m_managedForm.getParts().length > 0) {
            this.destroyPart((MCSectionPart)this.m_managedForm.getParts()[0]);
        }
        this.m_managedForm.getForm().setFocus();
    }

    public void destroyPart(MCSectionPart part) {
        this.m_managedForm.removePart((IFormPart)part);
        part.dispose();
        part.getSection().dispose();
        this.m_managedForm.reflow(true);
    }

    public Composite getContainer() {
        return this.m_container;
    }

    public FormToolkit getFormToolkit() {
        return this.m_managedForm.getToolkit();
    }

    public String createUniqueSectionPartTitle(String title) {
        int n = 1;
        title = String.valueOf(title) + ' ';
        for (IFormPart part : this.getParts()) {
            String s = ((SectionPart)part).getSection().getText();
            if (!s.startsWith(title)) continue;
            try {
                int chartNum = Integer.parseInt(s.substring(title.length()));
                if (chartNum < n) continue;
                n = chartNum + 1;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return String.valueOf(title) + Integer.toString(n);
    }

    public boolean hasSectionPartTitle(String title) {
        for (IFormPart part : this.getParts()) {
            String name = ((SectionPart)part).getSection().getText();
            if (!name.equals(title)) continue;
            return true;
        }
        return false;
    }
}

