/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.tabs.threads;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.IManagedForm;
import org.openjdk.jmc.console.ui.messages.internal.Messages;
import org.openjdk.jmc.console.ui.tabs.threads.IThreadsModel;
import org.openjdk.jmc.console.ui.tabs.threads.StackTraceContentProvider;
import org.openjdk.jmc.console.ui.tabs.threads.StackTraceLabelProvider;
import org.openjdk.jmc.ui.handlers.CopySelectionAction;
import org.openjdk.jmc.ui.handlers.InFocusHandlerActivator;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.CopySettings;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.FormatToolkit;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.misc.MCSectionPart;
import org.openjdk.jmc.ui.polling.PollManager;
import org.openjdk.jmc.ui.polling.RefreshPollAction;

public class StackTraceSectionPart
extends MCSectionPart
implements PollManager.Pollable,
ISelectionChangedListener {
    private final DateFormat m_dateFormat = DateFormat.getTimeInstance(2);
    private final IThreadsModel m_threadsModel;
    private final RefreshPollAction m_pollAction;
    private final TreeViewer tree;

    public StackTraceSectionPart(Composite parent, IManagedForm form, IWorkbenchPartSite site, IThreadsModel threadsModel) {
        super(parent, form.getToolkit(), 384);
        this.getSection().setText(Messages.StackTraceSectionPart_SECTION_TEXT);
        this.m_threadsModel = threadsModel;
        this.m_pollAction = new RefreshPollAction(Messages.StackTraceSectionPart_ACTION_REFRESH_STACK_TRACE_TEXT, this.m_threadsModel.getPollManager(), (PollManager.Pollable)this);
        this.getMCToolBarManager().add((IAction)this.m_pollAction);
        Composite body = this.createSectionBody(MCLayoutFactory.createMarginFreeFormPageLayout());
        Tree control = form.getToolkit().createTree(body, 268501762);
        control.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        control.setHeaderVisible(false);
        control.setLinesVisible(true);
        this.tree = new TreeViewer(control);
        StackTraceLabelProvider lp = new StackTraceLabelProvider();
        this.tree.setLabelProvider((IBaseLabelProvider)lp);
        this.tree.setAutoExpandLevel(2);
        this.tree.setContentProvider((IContentProvider)new StackTraceContentProvider(this.m_threadsModel));
        CopySelectionAction copyAction = new CopySelectionAction((StructuredViewer)this.tree, FormatToolkit.selectionFormatter((ILabelProvider[])new ILabelProvider[]{lp}));
        InFocusHandlerActivator.install((Control)control, (IAction)copyAction);
        IContributionItem copyMenu = CopySettings.getInstance().createContributionItem();
        MCContextMenuManager mm = MCContextMenuManager.create((Control)control);
        mm.appendToGroup("group.edit", (IAction)copyAction);
        mm.appendToGroup("group.edit", copyMenu);
        site.registerContextMenu((MenuManager)mm, (ISelectionProvider)this.tree);
    }

    public boolean poll() {
        DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!StackTraceSectionPart.this.m_threadsModel.isConnected()) {
                    StackTraceSectionPart.this.m_threadsModel.getPollManager().stop();
                }
                if (!StackTraceSectionPart.this.tree.getControl().isDisposed()) {
                    StackTraceSectionPart.this.tree.refresh();
                    StackTraceSectionPart.this.updateTimestamp();
                }
            }
        });
        return true;
    }

    public void updateTimestamp() {
        if (this.getSection() != null && !this.getSection().isDisposed()) {
            this.getSection().setDescription(NLS.bind((String)Messages.StackTraceSectionPart_SECTION_DESCRIPTION_DATE, (Object)this.m_dateFormat.format(new Date())));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.tree.setInput((Object)event.getSelection());
        this.updateTimestamp();
    }
}

