/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.descriptors;

import org.openjdk.jmc.joverflow.descriptors.AbstractCollectionDescriptor;
import org.openjdk.jmc.joverflow.descriptors.CollectionInstanceDescriptor;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectArray;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;

abstract class AbstractArrayBasedCollectionDescriptor
extends AbstractCollectionDescriptor
implements CollectionInstanceDescriptor.CapacityDifferentFromSize {
    protected final Factory factory;

    AbstractArrayBasedCollectionDescriptor(JavaObject col, Factory factory) {
        super(col);
        this.factory = factory;
    }

    @Override
    public int getSparsenessOverhead(int ptrSize) {
        int numNonEmptySlots;
        int capacity;
        if (this.factory.classDesc.isMap()) {
            JavaHeapObject[] elements;
            JavaObjectArray els = this.getElementsArray();
            if (els == null) {
                return -1;
            }
            capacity = els.getLength();
            numNonEmptySlots = 0;
            JavaHeapObject[] javaHeapObjectArray = elements = els.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                JavaHeapObject element = javaHeapObjectArray[n2];
                if (element != null) {
                    ++numNonEmptySlots;
                }
                ++n2;
            }
        } else {
            capacity = this.getCapacity();
            numNonEmptySlots = this.getNumElements();
        }
        if (numNonEmptySlots < capacity / 2) {
            return (capacity - numNonEmptySlots) * ptrSize;
        }
        return -1;
    }

    @Override
    public int getDefaultCapacity() {
        return this.factory.initialCapacity;
    }

    @Override
    public int getCapacity() {
        JavaObjectArray els = this.getElementsArray();
        if (els == null) {
            return 0;
        }
        return els.getLength();
    }

    @Override
    public void iterateList(CollectionInstanceDescriptor.ListIteratorCallback cb) {
        JavaHeapObject[] elements;
        JavaObjectArray elsArray = this.getElementsArray();
        if (elsArray == null) {
            return;
        }
        if (!cb.scanImplementationObject(elsArray)) {
            return;
        }
        JavaHeapObject[] javaHeapObjectArray = elements = elsArray.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            JavaHeapObject element = javaHeapObjectArray[n2];
            if (element != null && !cb.scanListElement(element)) break;
            ++n2;
        }
    }

    @Override
    public void iterateMap(CollectionInstanceDescriptor.MapIteratorCallback cb) {
        JavaObjectArray entriesArray = this.getElementsArray();
        if (entriesArray == null) {
            return;
        }
        if (!cb.scanImplementationObject(entriesArray)) {
            return;
        }
        int numElements = this.getNumElements();
        if (numElements == 0) {
            return;
        }
        JavaHeapObject[] entries = entriesArray.getElements();
        JavaThing[] entryFields = null;
        int keyFieldIdx = -1;
        int valueFieldIdx = -1;
        int nextFieldIdx = -1;
        JavaHeapObject[] javaHeapObjectArray = entries;
        int n = entries.length;
        int n2 = 0;
        block0: while (n2 < n) {
            JavaHeapObject entryThing = javaHeapObjectArray[n2];
            if (entryThing != null && entryThing instanceof JavaObject) {
                JavaObject entry = (JavaObject)entryThing;
                while (entry != null) {
                    if (!cb.scanImplementationObject(entry)) break;
                    if (keyFieldIdx == -1) {
                        keyFieldIdx = this.factory.getKeyFieldIdx(entry);
                        valueFieldIdx = this.factory.getValueFieldIdx(entry);
                        nextFieldIdx = this.factory.getEntryNextFieldIdx(entry);
                    }
                    entryFields = entry.getFields(entryFields);
                    JavaThing keyThing = entryFields[keyFieldIdx];
                    JavaThing valueThing = entryFields[valueFieldIdx];
                    JavaHeapObject key = null;
                    JavaHeapObject value = null;
                    if (keyThing instanceof JavaHeapObject) {
                        key = (JavaHeapObject)keyThing;
                    }
                    if (valueThing instanceof JavaHeapObject) {
                        value = (JavaHeapObject)valueThing;
                    }
                    if (!cb.scanMapEntry(key, value)) break block0;
                    JavaObject prevEntry = entry;
                    if (!(entryFields[nextFieldIdx] instanceof JavaObject) || (entry = (JavaObject)entryFields[nextFieldIdx]) == prevEntry) break;
                }
            }
            ++n2;
        }
    }

    @Override
    AbstractCollectionDescriptor.Factory getFactory() {
        return this.factory;
    }

    public JavaObjectArray getElementsArray() {
        JavaThing els = this.fields[this.factory.elsArrayFieldIdx];
        return els instanceof JavaObjectArray ? (JavaObjectArray)els : null;
    }

    protected int getDirectImplSize() {
        this.col.setVisitedAsCollectionImpl();
        int colSize = this.col.getSize();
        JavaObjectArray els = this.getElementsArray();
        if (els == null) {
            return colSize;
        }
        els.setVisitedAsCollectionImpl();
        return colSize + els.getSize();
    }

    protected int getMapEntriesImplSize() {
        int numEls = this.getNumElements();
        if (numEls == 0) {
            return 0;
        }
        JavaObjectArray entriesArray = this.getElementsArray();
        if (entriesArray == null) {
            return 0;
        }
        JavaThing[] entries = entriesArray.getElements();
        int nextFieldIdx = this.factory.getEntryNextFieldIdx(entries);
        if (nextFieldIdx == -1) {
            return 0;
        }
        JavaThing[] entryFields = null;
        int size = 0;
        JavaThing[] javaThingArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            JavaThing entryThing = javaThingArray[n2];
            if (entryThing != null && entryThing instanceof JavaObject) {
                JavaObject entry = (JavaObject)entryThing;
                while (entry != null && !entry.isVisitedAsCollectionImpl()) {
                    entry.setVisitedAsCollectionImpl();
                    size += entry.getSize();
                    entryFields = entry.getFields(entryFields);
                    JavaObject prevEntry = entry;
                    if (!(entryFields[nextFieldIdx] instanceof JavaObject) || (entry = (JavaObject)entryFields[nextFieldIdx]) == prevEntry) break;
                }
            }
            ++n2;
        }
        return size;
    }

    static abstract class Factory
    extends AbstractCollectionDescriptor.Factory {
        private final int elsArrayFieldIdx;
        private final int initialCapacity;

        Factory(JavaClass clazz, boolean isMap, String elsArrayFieldName, int initialCapacity, JavaClass[] implClasses, String[] parentColClassNames) {
            super(clazz, isMap, implClasses, parentColClassNames, false, new String[]{elsArrayFieldName});
            this.elsArrayFieldIdx = clazz.getInstanceFieldIndex(elsArrayFieldName);
            this.initialCapacity = initialCapacity;
        }

        Factory(JavaClass clazz, Factory superclassFactory) {
            super(clazz, superclassFactory);
            this.elsArrayFieldIdx = superclassFactory.elsArrayFieldIdx;
            this.initialCapacity = superclassFactory.initialCapacity;
        }
    }
}

