/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.descriptors;

import org.openjdk.jmc.joverflow.descriptors.AbstractArrayBasedCollectionDescriptor;
import org.openjdk.jmc.joverflow.descriptors.AbstractCollectionDescriptor;
import org.openjdk.jmc.joverflow.descriptors.CollectionInstanceDescriptor;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaInt;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectArray;

public class ArrayDequeDescriptor
extends AbstractArrayBasedCollectionDescriptor {
    private int numElements = -1;

    ArrayDequeDescriptor(JavaObject col, Factory factory) {
        super(col, factory);
    }

    @Override
    public int getNumElements() {
        if (this.numElements != -1) {
            return this.numElements;
        }
        JavaObjectArray elsArray = this.getElementsArray();
        if (elsArray == null) {
            this.numElements = 0;
            return this.numElements;
        }
        Factory f = (Factory)this.factory;
        int tail = ((JavaInt)this.fields[f.tailFieldIdx]).getValue();
        int head = ((JavaInt)this.fields[f.headFieldIdx]).getValue();
        this.numElements = tail - head & elsArray.getLength() - 1;
        return this.numElements;
    }

    @Override
    public int doGetImplSize() {
        return this.getDirectImplSize();
    }

    static class Factory
    extends AbstractArrayBasedCollectionDescriptor.Factory {
        private final int headFieldIdx;
        private final int tailFieldIdx;

        Factory(JavaClass clazz) {
            super(clazz, false, "elements", 16, new JavaClass[0], null);
            this.headFieldIdx = clazz.getInstanceFieldIndex("head");
            this.tailFieldIdx = clazz.getInstanceFieldIndex("tail");
        }

        private Factory(JavaClass clazz, AbstractArrayBasedCollectionDescriptor.Factory superclassFactory) {
            super(clazz, superclassFactory);
            this.headFieldIdx = ((Factory)superclassFactory).headFieldIdx;
            this.tailFieldIdx = ((Factory)superclassFactory).tailFieldIdx;
        }

        @Override
        AbstractCollectionDescriptor.Factory cloneForSubclass(JavaClass clazz) {
            return new Factory(clazz, this);
        }

        @Override
        CollectionInstanceDescriptor get(JavaObject col) {
            return new ArrayDequeDescriptor(col, this);
        }
    }
}

