/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.descriptors;

import org.openjdk.jmc.joverflow.descriptors.AbstractCollectionDescriptor;
import org.openjdk.jmc.joverflow.descriptors.CollectionInstanceDescriptor;
import org.openjdk.jmc.joverflow.descriptors.FullyUtilizedArrayListDescriptor;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;

public class CopyOnWriteArraySetDescriptor
extends AbstractCollectionDescriptor {
    private final Factory factory;
    private final FullyUtilizedArrayListDescriptor listDesc;

    private CopyOnWriteArraySetDescriptor(JavaObject col, Factory factory) {
        super(col);
        this.factory = factory;
        JavaThing alField = this.fields[factory.alFieldIdx];
        if (alField == null || !(alField instanceof JavaObject)) {
            this.listDesc = null;
            return;
        }
        JavaObject list = (JavaObject)alField;
        this.listDesc = (FullyUtilizedArrayListDescriptor)factory.cowaListDescFactory.get(list);
    }

    @Override
    protected int doGetImplSize() {
        if (this.listDesc == null) {
            return this.col.getSize();
        }
        this.listDesc.col.setVisitedAsCollectionImpl();
        return this.col.getSize() + (this.listDesc != null ? this.listDesc.getImplSize() : 0);
    }

    @Override
    Factory getFactory() {
        return this.factory;
    }

    @Override
    public int getNumElements() {
        return this.listDesc != null ? this.listDesc.getNumElements() : 0;
    }

    @Override
    public void iterateList(final CollectionInstanceDescriptor.ListIteratorCallback cb) {
        if (this.listDesc == null) {
            return;
        }
        this.listDesc.iterateList(new CollectionInstanceDescriptor.ListIteratorCallback(){

            @Override
            public boolean scanListElement(JavaHeapObject element) {
                return cb.scanListElement(element);
            }

            @Override
            public boolean scanImplementationObject(JavaHeapObject implObj) {
                return cb.scanImplementationObject(implObj);
            }
        });
    }

    @Override
    public void iterateMap(CollectionInstanceDescriptor.MapIteratorCallback cb) {
        throw new UnsupportedOperationException();
    }

    static class Factory
    extends AbstractCollectionDescriptor.Factory {
        private static final String AL_FIELD_NAME = "al";
        private final int alFieldIdx;
        private final FullyUtilizedArrayListDescriptor.Factory cowaListDescFactory;

        Factory(JavaClass cowaSetClazz, FullyUtilizedArrayListDescriptor.Factory cowaListDescFactory) {
            super(cowaSetClazz, false, new JavaClass[0], null, true, new String[0]);
            this.cowaListDescFactory = cowaListDescFactory;
            this.alFieldIdx = cowaSetClazz.getInstanceFieldIndex(AL_FIELD_NAME);
        }

        private Factory(JavaClass clazz, AbstractCollectionDescriptor.Factory superclassFactory) {
            super(clazz, superclassFactory);
            this.cowaListDescFactory = ((Factory)superclassFactory).cowaListDescFactory;
            this.alFieldIdx = ((Factory)superclassFactory).alFieldIdx;
        }

        @Override
        AbstractCollectionDescriptor.Factory cloneForSubclass(JavaClass clazz) {
            return new Factory(clazz, this);
        }

        @Override
        CollectionInstanceDescriptor get(JavaObject col) {
            return new CopyOnWriteArraySetDescriptor(col, this);
        }
    }
}

