/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.heap.model;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObjectVisitor;
import org.openjdk.jmc.joverflow.heap.model.JavaLazyReadObject;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.heap.parser.DumpCorruptedException;
import org.openjdk.jmc.joverflow.heap.parser.ReadBuffer;
import org.openjdk.jmc.joverflow.util.MiscUtils;
import org.openjdk.jmc.joverflow.util.StringInterner;

public class JavaObjectArray
extends JavaLazyReadObject {
    private final int length;

    public JavaObjectArray(JavaClass clazz, long objOfsInFile, int length, int[] dataChunk, int startPosInChunk, int globalObjectIndex) {
        super(clazz, objOfsInFile, dataChunk, startPosInChunk, globalObjectIndex);
        this.length = length;
    }

    @Override
    public final int getSize() {
        JavaClass clz = this.getClazz();
        return MiscUtils.getAlignedObjectSize(clz.getPointerSize() * this.length + clz.getArrayHeaderSize(), clz.getObjectAlignment());
    }

    @Override
    public final int getImplInclusiveSize() {
        return this.getSize();
    }

    @Override
    public String valueAsString() {
        return this.valueAsString(false);
    }

    public String valueAsString(boolean bigLimit) {
        JavaHeapObject[] elements = this.getElements();
        int limit = bigLimit ? 1000 : 32;
        StringBuilder result = new StringBuilder(limit * 16);
        String humanFriendlyName = this.getClazz().getHumanFriendlyName();
        result.append(humanFriendlyName);
        int arrayStartPos = humanFriendlyName.indexOf(91);
        if (arrayStartPos != -1) {
            result.insert(arrayStartPos + 1, elements.length);
        }
        result.append('{');
        int num = 0;
        JavaHeapObject[] javaHeapObjectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            JavaHeapObject element = javaHeapObjectArray[n2];
            if (num > 0) {
                result.append(", ");
            }
            if (num >= limit || !bigLimit && result.length() > 74) {
                result.append(" ...");
                break;
            }
            ++num;
            result.append(element != null ? element.valueAsString() : "null");
            ++n2;
        }
        result.append('}');
        return StringInterner.internString(result.toString());
    }

    public JavaHeapObject[] getElements() {
        Snapshot snapshot = this.getClazz().getSnapshot();
        byte[] data = this.getValue();
        int idSize = snapshot.getHprofPointerSize();
        JavaHeapObject[] elements = new JavaHeapObject[this.length];
        int index = 0;
        int i = 0;
        while (i < elements.length) {
            long id = this.objectIdAt(index, data);
            index += idSize;
            elements[i] = snapshot.getObjectForId(id);
            ++i;
        }
        return elements;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public void visitReferencedObjects(JavaHeapObjectVisitor v) {
        JavaHeapObject[] elements;
        super.visitReferencedObjects(v);
        JavaHeapObject[] javaHeapObjectArray = elements = this.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            JavaHeapObject element = javaHeapObjectArray[n2];
            if (element != null) {
                v.visit(element);
            }
            ++n2;
        }
    }

    @Override
    protected final byte[] readValue() throws IOException {
        if (this.length == 0) {
            return Snapshot.EMPTY_BYTE_ARRAY;
        }
        ReadBuffer buf = this.clazz.getReadBuffer();
        int idSize = this.clazz.getHprofPointerSize();
        long offset = this.getObjOfsInFile() + (long)(2 * idSize) + 8L;
        byte[] res = new byte[this.length * idSize];
        try {
            buf.get(offset, res);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new DumpCorruptedException.Runtime("object array size for array ID " + MiscUtils.toHex(this.readId()) + " at offset " + this.getObjOfsInFile() + " is " + res.length + " bytes, which exceeds heap dump file size");
        }
        return res;
    }
}

