/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.heap.parser.DumpCorruptedException;
import org.openjdk.jmc.joverflow.heap.parser.HprofParsingCancelledException;
import org.openjdk.jmc.joverflow.stats.DetailedStatsCalculator;
import org.openjdk.jmc.joverflow.stats.OverallStatsCalculator;
import org.openjdk.jmc.joverflow.support.HeapStats;
import org.openjdk.jmc.joverflow.support.ProblemRecorder;

public class StandardStatsCalculator {
    private final Snapshot snapshot;
    private final ProblemRecorder problemRecorder;
    private final boolean useBreadthFirst;
    private OverallStatsCalculator osc;
    private DetailedStatsCalculator dsc;
    private volatile int stage;

    public StandardStatsCalculator(Snapshot snapshot, ProblemRecorder problemRecorder, boolean useBreadthFirst) {
        this.snapshot = snapshot;
        this.problemRecorder = problemRecorder;
        this.useBreadthFirst = useBreadthFirst;
    }

    public HeapStats calculate() throws DumpCorruptedException, HprofParsingCancelledException {
        this.snapshot.setCalculatingStats(true);
        try {
            this.osc = new OverallStatsCalculator(this.snapshot);
            this.stage = 1;
            HeapStats hs = this.osc.calculate();
            this.osc = null;
            this.problemRecorder.initialize(this.snapshot, hs);
            this.dsc = new DetailedStatsCalculator(this.snapshot, hs, this.problemRecorder, this.useBreadthFirst);
            this.stage = 2;
            this.dsc.calculate();
            HeapStats heapStats = hs;
            return heapStats;
        }
        catch (DumpCorruptedException.Runtime ex) {
            throw ex.getCause();
        }
        finally {
            this.snapshot.setCalculatingStats(false);
        }
    }

    public synchronized int getProgressPercentage() {
        switch (this.stage) {
            case 0: {
                return 0;
            }
            case 1: {
                OverallStatsCalculator localOsc = this.osc;
                if (localOsc == null) {
                    return 33;
                }
                return localOsc.getProgressPercentage() / 3;
            }
            case 2: {
                return 33 + this.dsc.getProgressPercentage() * 2 / 3;
            }
        }
        return 0;
    }

    public synchronized void cancelCalculation() {
        DetailedStatsCalculator localDsc;
        OverallStatsCalculator localOsc = this.osc;
        if (localOsc != null) {
            this.osc.cancelCalculation();
        }
        if ((localDsc = this.dsc) != null) {
            localDsc.cancelCalculation();
        }
    }
}

