/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.support;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.support.ClassAndOvhdCombo;
import org.openjdk.jmc.joverflow.support.Constants;

public class ClassAndOvhdComboList
implements Cloneable {
    private LinkedList<ClassAndOvhdCombo> list;
    private int totalOverhead;

    public List<ClassAndOvhdCombo> getFinalList() {
        ArrayList<ClassAndOvhdCombo> result = new ArrayList<ClassAndOvhdCombo>(this.list.size());
        result.addAll(this.list);
        if (result.size() > 1) {
            result.sort(null);
        }
        return result;
    }

    public int getTotalOverhead() {
        return this.totalOverhead;
    }

    public void addCollectionInfo(JavaClass colClass, Constants.ProblemKind ovhdKind, int ovhd, int nInstances) {
        this.totalOverhead += ovhd;
        if (this.list == null) {
            this.list = new LinkedList();
            this.addNewEntry(colClass, ovhdKind, ovhd, nInstances);
            return;
        }
        this.addInfo(colClass, ovhdKind, ovhd, nInstances);
    }

    public void addCollectionInfoWithNumEls(JavaClass colClass, Constants.ProblemKind ovhdKind, int ovhd, int nInstances, long numElementsInCollection, int maxNumElements) {
        this.totalOverhead += ovhd;
        if (this.list == null) {
            this.list = new LinkedList();
            this.addNewEntryWithNumEls(colClass, ovhdKind, ovhd, nInstances, numElementsInCollection, maxNumElements);
            return;
        }
        this.addInfoWithNumEls(colClass, ovhdKind, ovhd, nInstances, numElementsInCollection, maxNumElements);
    }

    public void merge(ClassAndOvhdComboList other) {
        LinkedList<ClassAndOvhdCombo> otherList = other.list;
        if (otherList == null) {
            return;
        }
        for (ClassAndOvhdCombo entry : otherList) {
            if (entry instanceof ClassAndOvhdCombo.Extended) {
                ClassAndOvhdCombo.Extended extEntry = (ClassAndOvhdCombo.Extended)entry;
                this.addCollectionInfoWithNumEls(entry.getClazz(), entry.getProblemKind(), entry.getOverhead(), entry.getNumInstances(), extEntry.getTotalNumElements(), extEntry.getMaxNumElements());
                continue;
            }
            this.addCollectionInfo(entry.getClazz(), entry.getProblemKind(), entry.getOverhead(), entry.getNumInstances());
        }
    }

    public ClassAndOvhdComboList clone() {
        ClassAndOvhdComboList result = new ClassAndOvhdComboList();
        if (this.list != null) {
            result.list = new LinkedList();
            for (ClassAndOvhdCombo entry : this.list) {
                result.list.add(entry.clone());
            }
        }
        result.totalOverhead = this.totalOverhead;
        return result;
    }

    private void addInfo(JavaClass colClass, Constants.ProblemKind ovhdKind, int ovhd, int nInstances) {
        for (ClassAndOvhdCombo entry : this.list) {
            if (!entry.getClazz().getName().equals(colClass.getName()) || entry.getProblemKind() != ovhdKind) continue;
            entry.addInstances(nInstances, ovhd);
            return;
        }
        this.addNewEntry(colClass, ovhdKind, ovhd, nInstances);
    }

    private void addNewEntry(JavaClass colClass, Constants.ProblemKind ovhdKind, int ovhd, int nInstances) {
        this.list.add(new ClassAndOvhdCombo(colClass, ovhdKind, nInstances, ovhd));
    }

    private void addInfoWithNumEls(JavaClass colClass, Constants.ProblemKind ovhdKind, int ovhd, int nInstances, long numElementsInCollection, int maxNumElements) {
        for (ClassAndOvhdCombo entry : this.list) {
            if (!entry.getClazz().getName().equals(colClass.getName()) || entry.getProblemKind() != ovhdKind) continue;
            ((ClassAndOvhdCombo.Extended)entry).addInstances(nInstances, ovhd, numElementsInCollection, maxNumElements);
            return;
        }
        this.addNewEntryWithNumEls(colClass, ovhdKind, ovhd, nInstances, numElementsInCollection, maxNumElements);
    }

    private void addNewEntryWithNumEls(JavaClass colClass, Constants.ProblemKind ovhdKind, int ovhd, int nInstances, long numElementsInCollection, int maxNumElements) {
        this.list.add(new ClassAndOvhdCombo.Extended(colClass, ovhdKind, nInstances, ovhd, numElementsInCollection, maxNumElements));
    }
}

