/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.support;

import java.util.ArrayList;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.util.ValueWithIntId;

public class DupArrayStats {
    public final int nArrays;
    public final int nUniqueArrays;
    public final int nDifferentDupArrayValues;
    public final ArrayList<Entry> dupArrays;
    public final long dupArraysOverhead;

    public DupArrayStats(int nArrays, int nUniqueArrays, int nDifferentDupArrayValues, ArrayList<Entry> dupArrays, long dupArraysOverhead) {
        this.nArrays = nArrays;
        this.nUniqueArrays = nUniqueArrays;
        this.nDifferentDupArrayValues = nDifferentDupArrayValues;
        this.dupArrays = dupArrays;
        this.dupArraysOverhead = dupArraysOverhead;
    }

    public static class Entry
    implements ValueWithIntId {
        public final JavaValueArray firstArray;
        public final int internalId;
        public final int nArrayInstances;
        public final int overhead;
        private int runningRemainingOvhd;
        private int runningRemainingNInstances;

        public Entry(JavaValueArray firstArray, int internalId, int nArrayInstances, int overhead) {
            this.firstArray = firstArray;
            this.internalId = internalId;
            this.nArrayInstances = nArrayInstances;
            this.overhead = overhead;
            this.runningRemainingNInstances = nArrayInstances;
            this.runningRemainingOvhd = overhead;
        }

        @Override
        public int getId() {
            return this.internalId;
        }

        public int getOvhdForNextArrayCopy() {
            int result = this.runningRemainingOvhd / this.runningRemainingNInstances;
            this.runningRemainingOvhd -= result;
            --this.runningRemainingNInstances;
            return result;
        }
    }
}

