/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.util;

import org.openjdk.jmc.joverflow.util.NumberToIntMap;

public class LongToIntMap
extends NumberToIntMap {
    private long[] keys;

    public LongToIntMap(int expectedMaxSize) {
        super(expectedMaxSize);
    }

    @Override
    public void put(long key, int value) {
        int idx = this.hash(key);
        while (this.values[idx] != -1) {
            if (this.keys[idx] == key) {
                this.values[idx] = value;
                return;
            }
            idx = this.nextKeyIndex(idx);
        }
        this.keys[idx] = key;
        this.values[idx] = value;
        this.finishPut();
    }

    @Override
    public int get(long key) {
        int idx = this.hash(key);
        while (this.values[idx] != -1) {
            if (this.keys[idx] == key) {
                return this.values[idx];
            }
            idx = this.nextKeyIndex(idx);
        }
        return -1;
    }

    private int hash(long v) {
        int h = (int)(v ^ v >>> 32);
        h ^= h >>> 7 ^ h >>> 4;
        return (h &= Integer.MAX_VALUE) % this.capacity;
    }

    @Override
    protected void rehash(int newCapacity) {
        long time = System.currentTimeMillis();
        long[] oldKeys = this.keys;
        int[] oldValues = this.values;
        this.capacity = newCapacity;
        this.createTable();
        int i = 0;
        while (i < oldKeys.length) {
            if (oldValues[i] != -1) {
                this.put(oldKeys[i], oldValues[i]);
            }
            ++i;
        }
        this.rehashTime += System.currentTimeMillis() - time;
    }

    @Override
    protected void createTable() {
        this.threshold = this.capacity / 4 * 3;
        this.size = 0;
        this.keys = new long[this.capacity];
        this.values = new int[this.capacity];
        int i = 0;
        while (i < this.capacity) {
            this.values[i] = -1;
            ++i;
        }
    }
}

